﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>

namespace Aws {
namespace GuardDuty {
namespace Model {
enum class MalwareProtectionResourceType {
  NOT_SET,
  EBS_RECOVERY_POINT,
  EBS_SNAPSHOT,
  EBS_VOLUME,
  EC2_AMI,
  EC2_INSTANCE,
  EC2_RECOVERY_POINT,
  S3_RECOVERY_POINT,
  S3_BUCKET
};

namespace MalwareProtectionResourceTypeMapper {
AWS_GUARDDUTY_API MalwareProtectionResourceType GetMalwareProtectionResourceTypeForName(const Aws::String& name);

AWS_GUARDDUTY_API Aws::String GetNameForMalwareProtectionResourceType(MalwareProtectionResourceType value);
}  // namespace MalwareProtectionResourceTypeMapper
}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
