/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateInline
@GenerateCached(value=false)
public abstract class PyConvertOptionalToSizeNode
extends PNodeWithContext {
    public abstract int execute(Frame var1, Node var2, Object var3, int var4);

    @Specialization(guards={"isNone(value)"})
    int doOptional(PNone value, int defaultValue) {
        return defaultValue;
    }

    @Specialization(guards={"!isNone(value)", "!isNoValue(value)"})
    static int doObject(VirtualFrame frame, Node inliningTarget, Object value, int defaultValue, @Cached PRaiseNode raiseNode, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode) {
        if (!indexCheckNode.execute(inliningTarget, value)) {
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ARG_SHOULD_BE_INT_OR_NONE, value);
        }
        int limit = asSizeNode.executeExact((Frame)frame, inliningTarget, value);
        return limit;
    }
}

