/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.fop.image.analyser.AbstractImageReader;

public class EPSReader
extends AbstractImageReader {
    private long[] bbox;
    private boolean isAscii;
    long psStart = 0L;
    long psLength = 0L;
    long wmfStart = 0L;
    long wmfLength = 0L;
    long tiffStart = 0L;
    long tiffLength = 0L;
    private byte[] rawEps;
    private byte[] epsFile;
    private byte[] preview = null;

    public int[] getBBox() {
        int[] bbox = new int[]{(int)this.bbox[0], (int)this.bbox[1], (int)this.bbox[2], (int)this.bbox[3]};
        return bbox;
    }

    public byte[] getEpsFile() {
        return this.epsFile;
    }

    private long getLong(byte[] buf, int idx) {
        int b1 = buf[idx] & 0xFF;
        int b2 = buf[idx + 1] & 0xFF;
        int b3 = buf[idx + 2] & 0xFF;
        int b4 = buf[idx + 3] & 0xFF;
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    public String getMimeType() {
        return "image/eps";
    }

    public byte[] getPreview() {
        Object is = null;
        if (this.preview == null && this.tiffLength > 0L) {
            this.preview = new byte[(int)this.tiffLength];
            System.arraycopy(this.rawEps, (int)this.tiffStart, this.preview, 0, (int)this.tiffLength);
        }
        return this.preview;
    }

    private long[] readBBox() {
        long[] mbbox = null;
        int idx = 0;
        byte[] bbxName = "%%BoundingBox: ".getBytes();
        boolean found = false;
        while (!found && this.epsFile.length > idx + bbxName.length) {
            boolean sfound = true;
            int i = idx;
            i = idx;
            while (sfound && i - idx < bbxName.length) {
                if (bbxName[i - idx] != this.epsFile[i]) {
                    sfound = false;
                }
                ++i;
            }
            if (sfound) {
                found = true;
                idx = i;
                continue;
            }
            ++idx;
        }
        if (!found) {
            return mbbox;
        }
        mbbox = new long[4];
        idx += this.readLongString(mbbox, 0, idx);
        idx += this.readLongString(mbbox, 1, idx);
        idx += this.readLongString(mbbox, 2, idx);
        idx += this.readLongString(mbbox, 3, idx);
        return mbbox;
    }

    private void readEPSImage(BufferedInputStream fis) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] readBuf = new byte[20480];
        boolean index = false;
        boolean cont = true;
        try {
            int bytes_read;
            while ((bytes_read = fis.read(readBuf)) != -1) {
                baos.write(readBuf, 0, bytes_read);
            }
        }
        catch (IOException ex) {
            throw new IOException("Error while loading EPS image " + ex.getMessage());
        }
        byte[] file = baos.toByteArray();
        if (this.isAscii) {
            this.rawEps = null;
            this.epsFile = new byte[file.length];
            System.arraycopy(file, 0, this.epsFile, 0, this.epsFile.length);
        } else {
            this.rawEps = new byte[file.length];
            this.epsFile = new byte[(int)this.psLength];
            System.arraycopy(file, 0, this.rawEps, 0, this.rawEps.length);
            System.arraycopy(this.rawEps, (int)this.psStart, this.epsFile, 0, (int)this.psLength);
        }
    }

    private int readLongString(long[] mbbox, int i, int idx) {
        while (idx < this.epsFile.length && this.epsFile[idx] == 32) {
            ++idx;
        }
        int nidx = idx;
        while (nidx < this.epsFile.length && (this.epsFile[nidx] >= 48 && this.epsFile[nidx] <= 57 || this.epsFile[nidx] == 45)) {
            ++nidx;
        }
        byte[] num = new byte[nidx - idx];
        System.arraycopy(this.epsFile, idx, num, 0, nidx - idx);
        String ns = new String(num);
        mbbox[i] = Long.parseLong(ns);
        return 1 + nidx - idx;
    }

    public boolean verifySignature(String uri, BufferedInputStream fis) throws IOException {
        boolean isEPS = false;
        this.imageStream = fis;
        fis.mark(32);
        byte[] header = new byte[30];
        fis.read(header, 0, 30);
        fis.reset();
        if (this.getLong(header, 0) == -959196987L) {
            this.isAscii = false;
            isEPS = true;
            this.psStart = this.getLong(header, 4);
            this.psLength = this.getLong(header, 8);
            this.wmfStart = this.getLong(header, 12);
            this.wmfLength = this.getLong(header, 16);
            this.tiffStart = this.getLong(header, 20);
            this.tiffLength = this.getLong(header, 24);
        } else {
            byte[] epsh = "%!PS".getBytes();
            if (epsh[0] == header[0] && epsh[1] == header[1] && epsh[2] == header[2] && epsh[3] == header[3]) {
                this.isAscii = true;
                isEPS = true;
            }
        }
        if (isEPS) {
            this.readEPSImage(fis);
            this.bbox = this.readBBox();
            if (this.bbox != null) {
                this.width = (int)(this.bbox[2] - this.bbox[0]);
                this.height = (int)(this.bbox[3] - this.bbox[1]);
            } else {
                isEPS = false;
            }
        }
        return isEPS;
    }
}

