/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.actions.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionDispatcher;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.api.utils.ParserHelper;
import org.apache.unomi.metrics.MetricAdapter;
import org.apache.unomi.metrics.MetricsService;
import org.apache.unomi.scripting.ScriptExecutor;
import org.apache.unomi.services.actions.ActionExecutorDispatcher;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionExecutorDispatcherImpl
implements ActionExecutorDispatcher {
    private static final Logger logger = LoggerFactory.getLogger((String)ActionExecutorDispatcherImpl.class.getName());
    private final Map<String, ParserHelper.ValueExtractor> valueExtractors = new HashMap<String, ParserHelper.ValueExtractor>(11);
    private Map<String, ActionExecutor> executors = new ConcurrentHashMap<String, ActionExecutor>();
    private MetricsService metricsService;
    private Map<String, ActionDispatcher> actionDispatchers = new ConcurrentHashMap<String, ActionDispatcher>();
    private BundleContext bundleContext;
    private ScriptExecutor scriptExecutor;

    public void setMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setScriptExecutor(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    public ActionExecutorDispatcherImpl() {
        this.valueExtractors.putAll(ParserHelper.DEFAULT_VALUE_EXTRACTORS);
        this.valueExtractors.put("script", new ParserHelper.ValueExtractor(){

            public Object extract(String valueAsString, Event event) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                return ActionExecutorDispatcherImpl.this.executeScript(valueAsString, event);
            }
        });
    }

    public Action getContextualAction(Action action, Event event) {
        if (!ParserHelper.hasContextualParameter((Map)action.getParameterValues(), this.valueExtractors)) {
            return action;
        }
        Map values = ParserHelper.parseMap((Event)event, (Map)action.getParameterValues(), this.valueExtractors);
        Action n = new Action(action.getActionType());
        n.setParameterValues(values);
        return n;
    }

    @Override
    public int execute(final Action action, final Event event) {
        String actionKey = null;
        if (action.getActionType() != null) {
            actionKey = action.getActionType().getActionExecutor();
        }
        if (actionKey == null) {
            throw new UnsupportedOperationException("No service defined for : " + action.getActionTypeId());
        }
        int colonPos = actionKey.indexOf(":");
        if (colonPos > 0) {
            String actionPrefix = actionKey.substring(0, colonPos);
            String actionName = actionKey.substring(colonPos + 1);
            ActionDispatcher actionDispatcher = this.actionDispatchers.get(actionPrefix);
            if (actionDispatcher == null) {
                logger.warn("Couldn't find any action dispatcher for prefix '{}', action {} won't execute !", (Object)actionPrefix, (Object)actionKey);
            }
            return actionDispatcher.execute(action, event, actionName);
        }
        if (this.executors.containsKey(actionKey)) {
            final ActionExecutor actionExecutor = this.executors.get(actionKey);
            try {
                return (Integer)new MetricAdapter<Integer>(this.metricsService, this.getClass().getName() + ".action." + actionKey){

                    public Integer execute(Object ... args) throws Exception {
                        return actionExecutor.execute(ActionExecutorDispatcherImpl.this.getContextualAction(action, event), event);
                    }
                }.runWithTimer(new Object[0]);
            }
            catch (Exception e) {
                logger.error("Error executing action with key=" + actionKey, (Throwable)e);
            }
        }
        return 0;
    }

    public void bindExecutor(ServiceReference<ActionExecutor> actionExecutorServiceReference) {
        ActionExecutor actionExecutor = (ActionExecutor)this.bundleContext.getService(actionExecutorServiceReference);
        this.executors.put(actionExecutorServiceReference.getProperty("actionExecutorId").toString(), actionExecutor);
    }

    public void unbindExecutor(ServiceReference<ActionExecutor> actionExecutorServiceReference) {
        if (actionExecutorServiceReference == null) {
            return;
        }
        this.executors.remove(actionExecutorServiceReference.getProperty("actionExecutorId").toString());
    }

    public void bindDispatcher(ServiceReference<ActionDispatcher> actionDispatcherServiceReference) {
        ActionDispatcher actionDispatcher = (ActionDispatcher)this.bundleContext.getService(actionDispatcherServiceReference);
        this.actionDispatchers.put(actionDispatcher.getPrefix(), actionDispatcher);
    }

    public void unbindDispatcher(ServiceReference<ActionDispatcher> actionDispatcherServiceReference) {
        if (actionDispatcherServiceReference == null) {
            return;
        }
        ActionDispatcher actionDispatcher = (ActionDispatcher)this.bundleContext.getService(actionDispatcherServiceReference);
        if (actionDispatcher != null) {
            this.actionDispatchers.remove(actionDispatcher.getPrefix());
        }
    }

    protected Object executeScript(String script, Event event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("event", event);
        context.put("session", event.getSession());
        context.put("profile", event.getProfile());
        return this.scriptExecutor.execute(script, context);
    }
}

