/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta;

import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.Optional;
import javax.money.Monetary;
import javax.money.MonetaryContext;
import javax.money.MonetaryContextBuilder;
import javax.money.MonetaryOperator;
import javax.money.RoundingQuery;
import javax.money.RoundingQueryBuilder;

enum RoundedMoneyMonetaryOperatorFactory {
    INSTANCE;

    private static final int SCALE_DEFAULT = 2;

    MonetaryOperator getDefaultMonetaryOperator(MonetaryOperator rounding, MonetaryContext context, MonetaryContextBuilder monetaryContextBuilder) {
        if (Objects.nonNull(rounding)) {
            return rounding;
        }
        if (Objects.nonNull(context)) {
            return this.createUsingMonetaryContext(context, monetaryContextBuilder);
        }
        return Monetary.getDefaultRounding();
    }

    private MonetaryOperator createUsingMonetaryContext(MonetaryContext context, MonetaryContextBuilder monetaryContextBuilder) {
        MathContext mathContext = (MathContext)context.get(MathContext.class);
        if (Objects.isNull(mathContext)) {
            RoundingMode roundingMode = (RoundingMode)((Object)context.get(RoundingMode.class));
            if (Objects.nonNull((Object)roundingMode)) {
                int scale = Optional.ofNullable(context.getInt("scale")).orElse(2);
                monetaryContextBuilder.set((Object)roundingMode);
                monetaryContextBuilder.set("scale", scale);
                return Monetary.getRounding((RoundingQuery)((RoundingQueryBuilder)RoundingQueryBuilder.of().setScale(scale).set((Object)roundingMode)).build());
            }
            return Monetary.getDefaultRounding();
        }
        monetaryContextBuilder.set((Object)mathContext.getRoundingMode());
        monetaryContextBuilder.set("scale", 2);
        return Monetary.getRounding((RoundingQuery)((RoundingQueryBuilder)RoundingQueryBuilder.of().set((Object)mathContext)).setScale(2).build());
    }
}

