/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.analysis_engine.impl.TypeOrFeature_impl;
import org.apache.uima.fit.descriptor.LanguageCapability;
import org.apache.uima.fit.descriptor.MimeTypeCapability;
import org.apache.uima.fit.descriptor.SofaCapability;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.internal.ReflectionUtil;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.impl.Capability_impl;

public final class CapabilityFactory {
    private CapabilityFactory() {
    }

    public static Capability createCapability(Class<?> componentClass) {
        Annotation annotation;
        boolean sofaCapabilityPresent = ReflectionUtil.isAnnotationPresent(componentClass, SofaCapability.class);
        boolean typeCapabilityPresent = ReflectionUtil.isAnnotationPresent(componentClass, TypeCapability.class);
        boolean mimeTypeCapabilityPresent = ReflectionUtil.isAnnotationPresent(componentClass, MimeTypeCapability.class);
        boolean languageCapabilityPresent = ReflectionUtil.isAnnotationPresent(componentClass, LanguageCapability.class);
        if (!(sofaCapabilityPresent || typeCapabilityPresent || mimeTypeCapabilityPresent || languageCapabilityPresent)) {
            return null;
        }
        Capability_impl capability = new Capability_impl();
        if (languageCapabilityPresent) {
            annotation = ReflectionUtil.getAnnotation(componentClass, LanguageCapability.class);
            String[] languages = annotation.value();
            if (languages.length == 1 && languages[0].equals("org.apache.uima.fit.descriptor.LanguageCapability.NO_DEFAULT_VALUE")) {
                languages = new String[]{};
            }
            capability.setLanguagesSupported(languages);
        }
        if (mimeTypeCapabilityPresent) {
            annotation = ReflectionUtil.getAnnotation(componentClass, MimeTypeCapability.class);
            String[] mimeTypes = annotation.value();
            if (mimeTypes.length == 1 && mimeTypes[0].equals("org.apache.uima.fit.descriptor.MimeTypeCapability.NO_DEFAULT_VALUE")) {
                mimeTypes = new String[]{};
            }
            capability.setMimeTypesSupported(mimeTypes);
        }
        if (sofaCapabilityPresent) {
            annotation = ReflectionUtil.getAnnotation(componentClass, SofaCapability.class);
            String[] inputSofas = annotation.inputSofas();
            if (inputSofas.length == 1 && inputSofas[0].equals("org.apache.uima.fit.descriptor.SofaCapability.NO_DEFAULT_VALUE")) {
                inputSofas = new String[]{};
            }
            capability.setInputSofas(inputSofas);
            String[] outputSofas = annotation.outputSofas();
            if (outputSofas.length == 1 && outputSofas[0].equals("org.apache.uima.fit.descriptor.SofaCapability.NO_DEFAULT_VALUE")) {
                outputSofas = new String[]{};
            }
            capability.setOutputSofas(outputSofas);
        }
        if (typeCapabilityPresent) {
            annotation = ReflectionUtil.getAnnotation(componentClass, TypeCapability.class);
            String[] inputTypesOrFeatureNames = annotation.inputs();
            capability.setInputs(CapabilityFactory.createTypesOrFeatures(inputTypesOrFeatureNames));
            String[] outputTypesOrFeatureNames = annotation.outputs();
            capability.setOutputs(CapabilityFactory.createTypesOrFeatures(outputTypesOrFeatureNames));
        }
        return capability;
    }

    private static TypeOrFeature[] createTypesOrFeatures(String[] typesOrFeatureNames) {
        if (typesOrFeatureNames.length == 1 && typesOrFeatureNames[0].equals("org.apache.uima.fit.descriptor.TypeCapability.NO_DEFAULT_VALUE")) {
            return new TypeOrFeature[0];
        }
        ArrayList<TypeOrFeature_impl> typesOrFeatures = new ArrayList<TypeOrFeature_impl>();
        for (String name : typesOrFeatureNames) {
            TypeOrFeature_impl tof = new TypeOrFeature_impl();
            tof.setName(name);
            if (name.indexOf(":") == -1) {
                tof.setType(true);
            } else {
                tof.setType(false);
            }
            typesOrFeatures.add(tof);
        }
        return typesOrFeatures.toArray(new TypeOrFeature[typesOrFeatures.size()]);
    }
}

