/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSIteratorImplBase;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.cas.TOP;

public class AnnotationListFSIterator
extends FSIteratorImplBase<AnnotationFS> {
    private final List<AnnotationFS> list;
    private int pointer = 0;

    public AnnotationListFSIterator(List<AnnotationFS> list) {
        this.list = list;
    }

    public boolean isValid() {
        return this.pointer >= 0 && this.pointer < this.list.size();
    }

    public AnnotationFS get() throws NoSuchElementException {
        return this.list.get(this.pointer);
    }

    public void moveToNext() {
        ++this.pointer;
    }

    public void moveToPrevious() {
        --this.pointer;
    }

    public void moveToFirst() {
        this.pointer = 0;
    }

    public void moveToLast() {
        this.pointer = this.list.size() - 1;
    }

    public void moveTo(FeatureStructure fs) {
        for (int i = 0; i < this.list.size(); ++i) {
            AnnotationFS each = this.list.get(i);
            if (!each.equals(fs)) continue;
            this.pointer = i;
            break;
        }
    }

    public FSIterator<AnnotationFS> copy() {
        return new AnnotationListFSIterator(this.list);
    }

    public int ll_indexSizeMaybeNotCurrent() {
        throw new NotImplementedException("Not supported.");
    }

    public LowLevelIndex<AnnotationFS> ll_getIndex() {
        throw new NotImplementedException("Not supported.");
    }

    public int ll_maxAnnotSpan() {
        throw new NotImplementedException("Not supported.");
    }

    public boolean isIndexesHaveBeenUpdated() {
        throw new NotImplementedException("Not supported.");
    }

    public boolean maybeReinitIterator() {
        throw new NotImplementedException("Not supported.");
    }

    public void moveToFirstNoReinit() {
        throw new NotImplementedException("Not supported.");
    }

    public void moveToLastNoReinit() {
        throw new NotImplementedException("Not supported.");
    }

    public void moveToNoReinit(FeatureStructure fs) {
        throw new NotImplementedException("Not supported.");
    }

    public Comparator<TOP> getComparator() {
        throw new NotImplementedException("Not supported.");
    }

    public AnnotationFS getNvc() {
        throw new NotImplementedException("Not supported.");
    }

    public void moveToNextNvc() {
        throw new NotImplementedException("Not supported.");
    }

    public void moveToPreviousNvc() {
        throw new NotImplementedException("Not supported.");
    }

    public boolean hasPrevious() {
        throw new NotImplementedException("Not supported.");
    }

    public AnnotationFS previous() {
        throw new NotImplementedException("Not supported.");
    }

    public int nextIndex() {
        throw new NotImplementedException("Not supported.");
    }

    public int previousIndex() {
        throw new NotImplementedException("Not supported.");
    }

    public void set(AnnotationFS e) {
        throw new NotImplementedException("Not supported.");
    }

    public void add(AnnotationFS e) {
        throw new NotImplementedException("Not supported.");
    }
}

