/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.text.folding;

import java.util.ArrayList;
import org.apache.uima.ruta.ide.ui.text.folding.RutaFoldingMessages;
import org.eclipse.dltk.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.ui.text.folding.IFoldingPreferenceBlock;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RutaFoldingPreferenceBlock
extends AbstractConfigurationBlock
implements IFoldingPreferenceBlock {
    private ListBlock fExcludePatterns;
    private ListBlock fIncludePatterns;
    private OverlayPreferenceStore fOverlayStore;
    private OverlayPreferenceStore.OverlayKey[] fKeys;

    public RutaFoldingPreferenceBlock(OverlayPreferenceStore store, PreferencePage mainPreferencePage) {
        super(store, mainPreferencePage);
        this.fOverlayStore = store;
        this.fKeys = this.createKeys();
        this.fOverlayStore.addKeys(this.fKeys);
    }

    private OverlayPreferenceStore.OverlayKey[] createKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "editor_folding_blocks"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "editor_folding_lines_limit"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "editor_folding_include_list"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "editor_folding_exclude_list"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_init_blocks"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_init_comments"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_init_namespaces"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_comments_folding_enabled"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_comments_lines"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(Composite composite) {
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        inner.setLayout((Layout)layout);
        Composite blockFolding = this.createSubsection(inner, null, RutaFoldingMessages.RutaFoldingPreferenceBlock_10);
        blockFolding.setLayout((Layout)new GridLayout());
        this.addRadioButton(blockFolding, RutaFoldingMessages.RutaFoldingPreferenceBlock_11, "editor_folding_blocks", 0);
        this.addRadioButton(blockFolding, RutaFoldingMessages.RutaFoldingPreferenceBlock_12, "editor_folding_blocks", 2);
        this.fExcludePatterns = new ListBlock(blockFolding, "editor_folding_exclude_list");
        this.addRadioButton(blockFolding, RutaFoldingMessages.RutaFoldingPreferenceBlock_13, "editor_folding_blocks", 1);
        this.fIncludePatterns = new ListBlock(blockFolding, "editor_folding_include_list");
        IInputValidator val = new IInputValidator(){

            public String isValid(String number) {
                if (number.length() == 0) {
                    return PreferencesMessages.DLTKEditorPreferencePage_empty_input;
                }
                try {
                    int value = Integer.parseInt(number);
                    if (value < 2) {
                        return "You may input numbers >= 2.";
                    }
                }
                catch (NumberFormatException e) {
                    return "Input is not a number";
                }
                return null;
            }
        };
        this.addLabelledTextField(blockFolding, "Minimal amount of lines to be folded(>=2):", "editor_folding_lines_limit", 3, 1, true, val);
        Composite commentFolding = this.createSubsection(inner, null, RutaFoldingMessages.RutaFoldingPreferenceBlock_14);
        commentFolding.setLayout((Layout)new GridLayout());
        this.addCheckBox(commentFolding, RutaFoldingMessages.RutaFoldingPreferenceBlock_15, "editor_comments_folding_enabled", 0);
        Composite initialFolding = this.createSubsection(inner, null, RutaFoldingMessages.RutaFoldingPreferenceBlock_16);
        initialFolding.setLayout((Layout)new GridLayout());
        this.addCheckBox(initialFolding, RutaFoldingMessages.DefaultFoldingPreferenceBlock_headers, "editor_folding_init_comments", 0);
        this.addCheckBox(initialFolding, RutaFoldingMessages.DefaultFoldingPreferenceBlock_innerTypes, "editor_folding_init_namespaces", 0);
        this.addCheckBox(initialFolding, RutaFoldingMessages.DefaultFoldingPreferenceBlock_methods, "editor_folding_init_blocks", 0);
        return inner;
    }

    public void initialize() {
        super.initialize();
        this.fExcludePatterns.initialize();
        this.fIncludePatterns.initialize();
    }

    public void performDefaults() {
        super.performDefaults();
        this.fExcludePatterns.performDefault();
        this.fIncludePatterns.performDefault();
    }

    protected class ListBlock {
        private ListViewer fList;
        private String fKey;
        private Button fAddButton;
        private Button fRemoveButton;

        public ListBlock(Composite parent, String key) {
            this.fKey = key;
            this.createControl(parent);
        }

        private Control createControl(Composite parent) {
            Font font = parent.getFont();
            Composite comp = new Composite(parent, 0);
            GridLayout topLayout = new GridLayout();
            topLayout.numColumns = 2;
            topLayout.marginHeight = 0;
            topLayout.marginWidth = 0;
            comp.setLayout((Layout)topLayout);
            GridData gd = new GridData(1808);
            comp.setLayoutData((Object)gd);
            this.fList = new ListViewer(comp);
            gd = new GridData(1808);
            gd.heightHint = 6;
            this.fList.getControl().setLayoutData((Object)gd);
            Composite pathButtonComp = new Composite(comp, 0);
            GridLayout pathButtonLayout = new GridLayout();
            pathButtonLayout.marginHeight = 0;
            pathButtonLayout.marginWidth = 0;
            pathButtonComp.setLayout((Layout)pathButtonLayout);
            gd = new GridData(258);
            pathButtonComp.setLayoutData((Object)gd);
            pathButtonComp.setFont(font);
            this.fAddButton = this.createPushButton(pathButtonComp, RutaFoldingMessages.RutaFoldingPreferenceBlock_0);
            this.fAddButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    IInputValidator validator = new IInputValidator(){

                        public String isValid(String newText) {
                            if (newText.trim().length() > 0 && newText.matches("[_a-zA-Z]*")) {
                                return null;
                            }
                            return RutaFoldingMessages.RutaFoldingPreferenceBlock_2;
                        }
                    };
                    InputDialog dlg = new InputDialog(null, RutaFoldingMessages.RutaFoldingPreferenceBlock_3, RutaFoldingMessages.RutaFoldingPreferenceBlock_4, "", validator);
                    if (dlg.open() == 0) {
                        ListBlock.this.fList.add((Object)dlg.getValue());
                        ListBlock.this.save();
                    }
                }
            });
            this.fRemoveButton = this.createPushButton(pathButtonComp, RutaFoldingMessages.RutaFoldingPreferenceBlock_6);
            this.fRemoveButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ISelection s = ListBlock.this.fList.getSelection();
                    if (s instanceof IStructuredSelection) {
                        IStructuredSelection sel = (IStructuredSelection)s;
                        ListBlock.this.fList.remove(sel.toArray());
                        ListBlock.this.save();
                    }
                }
            });
            return comp;
        }

        protected Button createPushButton(Composite parent, String label) {
            Button button = new Button(parent, 8);
            button.setFont(parent.getFont());
            if (label != null) {
                button.setText(label);
            }
            GridData gd = new GridData();
            button.setLayoutData((Object)gd);
            gd.widthHint = this.getButtonWidthHint(button);
            gd.horizontalAlignment = 4;
            return button;
        }

        public int getButtonWidthHint(Button button) {
            button.setFont(JFaceResources.getDialogFont());
            PixelConverter converter = new PixelConverter((Control)button);
            int widthHint = converter.convertHorizontalDLUsToPixels(61);
            return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        }

        private String[] getEntries() {
            return this.fList.getList().getItems();
        }

        private void setEntries(String[] items) {
            this.fList.remove((Object[])this.fList.getList().getItems());
            for (int i = 0; i < items.length; ++i) {
                if (items[i].trim().length() <= 0) continue;
                this.fList.add((Object)items[i]);
            }
        }

        public void save() {
            String[] items = this.getEntries();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < items.length; ++i) {
                buf.append(items[i]);
                if (i == items.length - 1) continue;
                buf.append(",");
            }
            RutaFoldingPreferenceBlock.this.getPreferenceStore().setValue(this.fKey, buf.toString());
        }

        public void initialize() {
            String val = RutaFoldingPreferenceBlock.this.getPreferenceStore().getString(this.fKey);
            if (val != null) {
                String[] items = val.split(",");
                this.setEntries(items);
            }
        }

        public void performDefault() {
            String val = RutaFoldingPreferenceBlock.this.getPreferenceStore().getDefaultString(this.fKey);
            if (val != null) {
                String[] items = val.split(",");
                this.setEntries(items);
            }
        }
    }
}

