/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.push;

import jakarta.faces.component.UIOutput;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.UIWebsocket;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.PartialViewContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.event.PreRenderViewEvent;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebsocketFacesListener
implements SystemEventListener {
    private static final String SCRIPT_OPEN = "faces.push.open('%s');";
    private static final String SCRIPT_CLOSE = "faces.push.close('%s');";

    public static void subscribeIfNecessary(FacesContext context) {
        UIViewRoot view = context.getViewRoot();
        List<SystemEventListener> listeners = view.getListenersForEventClass(PostAddToViewEvent.class);
        if (listeners == null || !listeners.stream().anyMatch(l -> l instanceof WebsocketFacesListener)) {
            view.subscribeToViewEvent(PreRenderViewEvent.class, new WebsocketFacesListener());
        }
    }

    public static boolean isNew(FacesContext context, UIWebsocket websocket) {
        return WebsocketFacesListener.getInitializedWebsockets(context).putIfAbsent(websocket.getClientId(context), websocket.isConnected()) == null;
    }

    @Override
    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    @Override
    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (!(event instanceof PreRenderViewEvent)) {
            return;
        }
        FacesContext context = ((ComponentSystemEvent)event).getFacesContext();
        Map<String, Boolean> initializedWebsockets = WebsocketFacesListener.getInitializedWebsockets(context);
        if (!context.getPartialViewContext().isAjaxRequest()) {
            initializedWebsockets.clear();
        }
        for (Map.Entry<String, Boolean> initializedWebsocket : initializedWebsockets.entrySet()) {
            String clientId = initializedWebsocket.getKey();
            UIWebsocket websocket = (UIWebsocket)context.getViewRoot().findComponent(clientId);
            boolean connected = websocket.isRendered() && websocket.isConnected();
            boolean previouslyConnected = initializedWebsocket.setValue(connected);
            if (previouslyConnected == connected) continue;
            String script = String.format(connected ? SCRIPT_OPEN : SCRIPT_CLOSE, clientId);
            PartialViewContext pvc = context.getPartialViewContext();
            if (pvc.isAjaxRequest() && !pvc.isRenderAll()) {
                context.getPartialViewContext().getEvalScripts().add(script);
                continue;
            }
            UIOutput outputScript = new UIOutput();
            outputScript.setRendererType("jakarta.faces.resource.Script");
            UIOutput content = new UIOutput();
            content.setValue(script);
            outputScript.getChildren().add(content);
            context.getViewRoot().addComponentResource(context, outputScript, "body");
        }
    }

    private static Map<String, Boolean> getInitializedWebsockets(FacesContext context) {
        Map<String, Object> viewScope = context.getViewRoot().getViewMap();
        HashMap initializedWebsockets = (HashMap)viewScope.get(WebsocketFacesListener.class.getName());
        if (initializedWebsockets == null) {
            initializedWebsockets = new HashMap();
            viewScope.put(WebsocketFacesListener.class.getName(), initializedWebsockets);
        }
        return initializedWebsockets;
    }
}

