/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.quality.ISOMetadata;
import org.apache.sis.util.internal.CollectionsExt;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.quality.Element;
import org.opengis.util.InternationalString;

@XmlType(name="DQ_MeasureReference_Type", propOrder={"measureIdentification", "namesOfMeasure", "measureDescription"})
@XmlRootElement(name="DQ_MeasureReference")
@UML(identifier="DQ_MeasureReference", specification=Specification.UNSPECIFIED)
public class DefaultMeasureReference
extends ISOMetadata {
    private static final long serialVersionUID = -1841855681786546466L;
    private Identifier measureIdentification;
    private Collection<InternationalString> namesOfMeasure;
    private InternationalString measureDescription;

    public DefaultMeasureReference() {
    }

    public DefaultMeasureReference(DefaultMeasureReference object) {
        super(object);
        if (object != null) {
            this.measureIdentification = object.getMeasureIdentification();
            this.measureDescription = object.getMeasureDescription();
            this.namesOfMeasure = this.copyCollection(object.getNamesOfMeasure(), InternationalString.class);
        }
    }

    final boolean setLegacy(Element element) {
        this.measureIdentification = element.getMeasureIdentification();
        boolean bl = null != this.measureIdentification;
        this.namesOfMeasure = this.copyCollection(element.getNamesOfMeasure(), InternationalString.class);
        this.measureDescription = CollectionsExt.first(element.getNamesOfMeasure());
        return bl | null != this.namesOfMeasure | null != this.measureDescription;
    }

    @XmlElement(name="measureIdentification")
    @UML(identifier="measureIdentification", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public Identifier getMeasureIdentification() {
        return this.measureIdentification;
    }

    public void setMeasureIdentification(Identifier newValue) {
        this.checkWritePermission(this.measureIdentification);
        this.measureIdentification = newValue;
    }

    @XmlElement(name="nameOfMeasure")
    @UML(identifier="nameOfMeasure", obligation=Obligation.CONDITIONAL, specification=Specification.UNSPECIFIED)
    public Collection<InternationalString> getNamesOfMeasure() {
        this.namesOfMeasure = this.nonNullCollection(this.namesOfMeasure, InternationalString.class);
        return this.namesOfMeasure;
    }

    public void setNamesOfMeasure(Collection<? extends InternationalString> newValues) {
        this.namesOfMeasure = this.writeCollection(newValues, this.namesOfMeasure, InternationalString.class);
    }

    @XmlElement(name="measureDescription")
    @UML(identifier="measureDescription", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public InternationalString getMeasureDescription() {
        return this.measureDescription;
    }

    public void setMeasureDescription(InternationalString newValue) {
        this.checkWritePermission(this.measureDescription);
        this.measureDescription = newValue;
    }
}

