/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.reparent;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.common.BadNodePlacementError;
import com.google.gxp.compiler.base.Concatenation;
import com.google.gxp.compiler.base.Conditional;
import com.google.gxp.compiler.base.Constructor;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.FormalTypeParameter;
import com.google.gxp.compiler.base.ImplementsDeclaration;
import com.google.gxp.compiler.base.Import;
import com.google.gxp.compiler.base.JavaAnnotation;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.Root;
import com.google.gxp.compiler.base.ThrowsDeclaration;
import com.google.gxp.compiler.reparent.Attribute;
import com.google.gxp.compiler.reparent.AttributeMap;
import com.google.gxp.compiler.reparent.DuplicateImportError;
import com.google.gxp.compiler.reparent.Parts;
import java.util.Collections;
import java.util.List;

class EditableParts
implements Parts {
    private final List<Bucket<?>> buckets = Lists.newArrayList();
    private final Bucket<Root> roots = this.newBucket();
    private final Bucket<Constructor> constructors = this.newBucket();
    private final Bucket<Expression> values = this.newBucket();
    private final Bucket<Import> imports = this.newBucket();
    private final Bucket<ImplementsDeclaration> implementsDeclarations = this.newBucket();
    private final Bucket<ThrowsDeclaration> throwsDeclarations = this.newBucket();
    private final Bucket<Parameter> parameters = this.newBucket();
    private final Bucket<FormalTypeParameter> formalTypeParameters = this.newBucket();
    private final Bucket<Conditional.Clause> clauses = this.newBucket();
    private final Bucket<JavaAnnotation> javaAnnotations = this.newBucket();
    private final AttributeMap attrMap;
    private final AlertSink alertSink;
    private final Node forNode;

    EditableParts(AlertSink alertSink, Node forNode) {
        this.alertSink = Preconditions.checkNotNull(alertSink);
        this.forNode = Preconditions.checkNotNull(forNode);
        this.attrMap = new AttributeMap(alertSink, forNode);
    }

    @Override
    public List<Root> getRoots() {
        return this.roots.get();
    }

    @Override
    public List<Constructor> getConstructors() {
        return this.constructors.get();
    }

    @Override
    public List<Import> getImports() {
        return this.imports.get();
    }

    @Override
    public List<ImplementsDeclaration> getImplementsDeclarations() {
        return this.implementsDeclarations.get();
    }

    @Override
    public List<ThrowsDeclaration> getThrowsDeclarations() {
        return this.throwsDeclarations.get();
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters.get();
    }

    @Override
    public List<FormalTypeParameter> getFormalTypeParameters() {
        return this.formalTypeParameters.get();
    }

    @Override
    public Expression getContent() {
        return Concatenation.create(this.forNode.getSourcePosition(), null, this.values.get());
    }

    @Override
    public List<Conditional.Clause> getClauses() {
        return this.clauses.get();
    }

    @Override
    public List<JavaAnnotation> getJavaAnnotations() {
        return this.javaAnnotations.get();
    }

    @Override
    public AttributeMap getAttributes() {
        return this.attrMap;
    }

    @Override
    public void reportUnused() {
        for (Bucket<?> bucket : this.buckets) {
            bucket.reportUnused();
        }
        this.attrMap.reportUnusedAttributes();
    }

    void accumulate(Expression value) {
        this.values.add(value);
    }

    void accumulate(Import imp) {
        if (this.imports.contains(imp)) {
            this.alertSink.add(new DuplicateImportError(imp));
        } else {
            this.imports.add(imp);
        }
    }

    void accumulate(ImplementsDeclaration implementsDeclaration) {
        this.implementsDeclarations.add(implementsDeclaration);
    }

    void accumulate(ThrowsDeclaration throwsDeclaration) {
        this.throwsDeclarations.add(throwsDeclaration);
    }

    void accumulate(Parameter parameter) {
        this.parameters.add(parameter);
    }

    void accumulate(FormalTypeParameter formalTypeParameter) {
        this.formalTypeParameters.add(formalTypeParameter);
    }

    void accumulate(Root root) {
        this.roots.add(root);
    }

    void accumulate(Constructor constructor) {
        this.constructors.add(constructor);
    }

    void accumulate(Conditional.Clause clause) {
        this.clauses.add(clause);
    }

    void accumulate(Attribute attribute) {
        this.attrMap.add(Preconditions.checkNotNull(attribute));
    }

    void accumulate(JavaAnnotation javaAnnotation) {
        this.javaAnnotations.add(javaAnnotation);
    }

    private <T extends Node> Bucket<T> newBucket() {
        return new Bucket();
    }

    private class Bucket<T extends Node> {
        private final List<T> nodes = Lists.newArrayList();
        private boolean used = true;

        private Bucket() {
            EditableParts.this.buckets.add(this);
        }

        public void add(T node) {
            this.nodes.add(Preconditions.checkNotNull(node));
            this.used = false;
        }

        public List<T> get() {
            this.used = true;
            return Collections.unmodifiableList(this.nodes);
        }

        public boolean contains(T node) {
            return this.nodes.contains(node);
        }

        public void reportUnused() {
            if (!this.used) {
                for (Node node : this.nodes) {
                    if (node instanceof Expression && ((Expression)node).alwaysOnlyWhitespace()) continue;
                    EditableParts.this.alertSink.add(new BadNodePlacementError(node, EditableParts.this.forNode));
                }
            }
        }
    }
}

