/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.flatten;

import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.alerts.AlertSetBuilder;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.base.AttrBundleReference;
import com.google.gxp.compiler.base.Concatenation;
import com.google.gxp.compiler.base.Conditional;
import com.google.gxp.compiler.base.ConvertibleToContent;
import com.google.gxp.compiler.base.EscapeExpression;
import com.google.gxp.compiler.base.ExampleExpression;
import com.google.gxp.compiler.base.ExceptionExpression;
import com.google.gxp.compiler.base.ExhaustiveExpressionVisitor;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.IsXmlExpression;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.OutputElement;
import com.google.gxp.compiler.base.Root;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.flatten.ContentFlattenedTree;
import com.google.gxp.compiler.reparent.Attribute;
import com.google.gxp.compiler.schema.AttributeValidator;
import com.google.gxp.compiler.schema.DocType;
import com.google.gxp.compiler.schema.ElementValidator;
import com.google.gxp.compiler.schema.Schema;
import com.google.gxp.compiler.validate.ValidatedTree;
import java.util.ArrayList;

public class ContentFlattener
implements Function<ValidatedTree, ContentFlattenedTree> {
    @Override
    public ContentFlattenedTree apply(ValidatedTree tree) {
        AlertSetBuilder alertSetBuilder = new AlertSetBuilder(tree.getAlerts());
        Root root = tree.getRoot().acceptVisitor(new Visitor(alertSetBuilder));
        return new ContentFlattenedTree(tree.getSourcePosition(), alertSetBuilder.buildAndClear(), root);
    }

    private static class Visitor
    extends ExhaustiveExpressionVisitor {
        private final AlertSink alertSink;

        Visitor(AlertSink alertSink) {
            this.alertSink = Preconditions.checkNotNull(alertSink);
        }

        private Expression flattenDocType(OutputElement element, DocType docType) {
            Expression sgmlDoctype;
            Schema elementSchema = element.getSchema();
            StringConstant xmlDoctype = new StringConstant(element, elementSchema, docType.toXml(element.getLocalName()));
            if (docType.isSgmlCompatible()) {
                sgmlDoctype = new StringConstant(element, elementSchema, docType.toSgml(element.getLocalName()));
            } else {
                String exceptionMessage = String.format("Doctype '%s' incompatible with non-XML syntax", docType.getName());
                sgmlDoctype = new ExceptionExpression(element.getSourcePosition(), elementSchema, ExceptionExpression.Kind.NOT_SUPPORTED_IN_SGML_MODE, exceptionMessage);
            }
            return new Conditional(element, elementSchema, new IsXmlExpression(element, elementSchema), xmlDoctype, sgmlDoctype);
        }

        private Expression flattenXmlns(OutputElement element) {
            Schema elementSchema = element.getSchema();
            String xmlns = elementSchema.getNamespaceUri();
            ArrayList<Expression> concatList = Lists.newArrayList();
            concatList.add(new StringConstant(element, elementSchema, " xmlns"));
            if (elementSchema.getTagPrefix() != null) {
                concatList.add(new StringConstant(element, elementSchema, ":"));
                concatList.add(new StringConstant(element, elementSchema, elementSchema.getTagPrefix()));
            }
            concatList.add(new StringConstant(element, elementSchema, "=\""));
            concatList.add(new StringConstant(element, elementSchema, CharEscapers.xmlEscaper().escape(xmlns)));
            concatList.add(new StringConstant(element, elementSchema, "\""));
            return new Conditional(element, elementSchema, new IsXmlExpression(element, elementSchema), Concatenation.create(element.getSourcePosition(), elementSchema, concatList), new StringConstant(element, elementSchema, ""));
        }

        @Override
        public Expression visitOutputElement(OutputElement element) {
            ArrayList<Expression> values = Lists.newArrayList();
            ElementValidator elementValidator = element.getValidator();
            Schema elementSchema = element.getSchema();
            String tagPrefix = elementSchema.getTagPrefix();
            DocType docType = element.getDocType();
            if (docType != null) {
                values.add(this.flattenDocType(element, docType));
            }
            values.add(new StringConstant(element, elementSchema, "<"));
            if (tagPrefix != null) {
                values.add(new StringConstant(element, elementSchema, tagPrefix + ":"));
            }
            values.add(new StringConstant(element, elementSchema, element.getLocalName()));
            if (docType != null) {
                values.add(this.flattenXmlns(element));
            }
            for (Attribute attr : element.getAttributes()) {
                AttributeValidator attrValidator = elementValidator.getAttributeValidator(attr.getName());
                StringConstant empty = new StringConstant(attr, elementSchema, "");
                if (attrValidator.isFlagSet(AttributeValidator.Flag.BOOLEAN)) {
                    Expression attrValue = attr.getValue().acceptVisitor(this);
                    if (attrValue.hasStaticString()) {
                        values.add(this.buildBooleanAttrExpression(attr, element));
                        continue;
                    }
                    if (attrValue instanceof ConvertibleToContent) {
                        ConvertibleToContent ctc = (ConvertibleToContent)attrValue;
                        attrValue = ctc.getSubexpression();
                    }
                    values.add(new Conditional(element, elementSchema, attrValue, this.buildBooleanAttrExpression(attr, element), empty));
                    continue;
                }
                String example = attrValidator.getExample();
                Expression condition = attr.getCondition();
                if (condition != null) {
                    values.add(new Conditional(element, elementSchema, condition, this.buildAttrExpression(attr, element, example), empty));
                    continue;
                }
                values.add(this.buildAttrExpression(attr, element, example));
            }
            for (String attrBundle : element.getAttrBundles()) {
                values.add(new EscapeExpression(elementSchema, new AttrBundleReference((Node)element, attrBundle)));
            }
            if (elementValidator.isFlagSet(ElementValidator.Flag.NOENDTAG)) {
                values.add(new Conditional(element, elementSchema, new IsXmlExpression(element, elementSchema), new StringConstant(element, elementSchema, " /"), new StringConstant(element, elementSchema, "")));
            }
            values.add(new StringConstant(element, elementSchema, ">"));
            values.add(element.getContent().acceptVisitor(this));
            if (!elementValidator.isFlagSet(ElementValidator.Flag.NOENDTAG)) {
                values.add(new StringConstant(element, elementSchema, "</"));
                if (tagPrefix != null) {
                    values.add(new StringConstant(element, elementSchema, tagPrefix + ":"));
                }
                values.add(new StringConstant(element, elementSchema, element.getLocalName() + ">"));
            }
            return Concatenation.create(element.getSourcePosition(), elementSchema, values);
        }

        private Expression buildAttrExpression(Attribute attr, OutputElement element, String example) {
            boolean surroundWithExample = false;
            ArrayList<Expression> list = Lists.newArrayList();
            list.add(new StringConstant(attr, element.getSchema(), " " + attr.getName() + "=\""));
            Expression value = attr.getValue().acceptVisitor(this);
            if (!value.hasStaticString()) {
                if (example != null) {
                    value = new ExampleExpression(value, example);
                } else {
                    surroundWithExample = true;
                }
            }
            list.add(value);
            list.add(new StringConstant(attr, element.getSchema(), "\""));
            Expression flattenedAttr = Concatenation.create(element.getSourcePosition(), element.getSchema(), list);
            return surroundWithExample ? new ExampleExpression(flattenedAttr, "") : flattenedAttr;
        }

        private Expression buildBooleanAttrExpression(Attribute attr, OutputElement element) {
            Schema elementSchema = element.getSchema();
            ArrayList<Expression> values = Lists.newArrayList();
            values.add(new StringConstant(attr, elementSchema, " " + attr.getName()));
            values.add(new Conditional(attr, elementSchema, new IsXmlExpression(attr, elementSchema), new StringConstant(attr, elementSchema, "=\"" + attr.getName() + "\""), new StringConstant(attr, elementSchema, "")));
            return Concatenation.create(attr.getSourcePosition(), elementSchema, values);
        }
    }
}

