/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.dot;

import com.google.gxp.com.google.common.base.CharEscaper;
import com.google.gxp.com.google.common.base.CharEscaperBuilder;
import com.google.gxp.com.google.common.base.Join;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.dot.GraphSink;
import com.google.gxp.compiler.dot.NodeShape;
import com.google.gxp.compiler.io.CIndenter;
import java.util.ArrayList;
import java.util.Map;

public class DotWriter
implements GraphSink {
    private final CIndenter out;
    private static CharEscaper DOT_ESCAPER = new CharEscaperBuilder().addEscape('\n', "\\n").addEscape('\r', "\\r").addEscape('\t', "\\t").addEscape('\\', "\\\\").addEscape('\"', "\\\"").addEscape('{', "\\{").addEscape('}', "\\}").addEscape('<', "\\<").addEscape('>', "\\>").addEscape('|', "\\|").addEscape(' ', "\\ ").toEscaper();

    public DotWriter(Appendable out) {
        this.out = new CIndenter(out, new String[0]);
    }

    @Override
    public void digraphStart(String name) {
        this.out.appendLine(String.format("digraph %s {", name));
    }

    @Override
    public void digraphEnd() {
        this.out.appendLine("}");
    }

    @Override
    public void simpleNode(String nodeId, NodeShape shape, String label) {
        this.out.appendLine(String.format("node%s [label=\"%s\",shape=%s];", new Object[]{nodeId, DotWriter.dotEscape(label), shape}));
    }

    @Override
    public void recordNode(String nodeId, Map<String, String> properties) {
        ArrayList<String> names = Lists.newArrayListWithExpectedSize(properties.size());
        ArrayList<String> values = Lists.newArrayListWithExpectedSize(properties.size());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            names.add(DotWriter.dotEscape(entry.getKey()));
            values.add(DotWriter.dotEscape(entry.getValue()));
        }
        this.out.appendLine(String.format("node%s [label=\"{%s} | {%s}\",shape=Mrecord];", nodeId, Join.join(" | ", names), Join.join(" | ", values)));
    }

    @Override
    public void edge(String fromNodeId, String label, String toNodeId) {
        String suffix = label == null ? "" : String.format(" [label=\"%s\"]", DotWriter.dotEscape(label));
        this.out.appendLine(String.format("node%s -> node%s%s;\n", fromNodeId, toNodeId, suffix));
    }

    private static String dotEscape(String s) {
        return DOT_ESCAPER.escape(s);
    }
}

