/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.annotations.utils;

import java.lang.annotation.Annotation;
import org.apache.commons.beanutils.MethodUtils;

public class AnnotationUtils {
    private static final String VALUE = "value";
    private static final String PATTERN = "pattern";
    private static final String NAMESPACE_URI = "namespaceURI";
    private static final String FIRE_ON_BEGIN = "fireOnBegin";

    private AnnotationUtils() {
    }

    public static Object getAnnotationValue(Annotation annotation) {
        return AnnotationUtils.invokeAnnotationMethod(annotation, VALUE);
    }

    public static String getAnnotationPattern(Annotation annotation) {
        Object ret = AnnotationUtils.invokeAnnotationMethod(annotation, PATTERN);
        if (ret != null) {
            return (String)ret;
        }
        return null;
    }

    public static String getAnnotationNamespaceURI(Annotation annotation) {
        Object ret = AnnotationUtils.invokeAnnotationMethod(annotation, NAMESPACE_URI);
        if (ret != null) {
            return (String)ret;
        }
        return null;
    }

    public static boolean getFireOnBegin(Annotation annotation) {
        Object ret = AnnotationUtils.invokeAnnotationMethod(annotation, FIRE_ON_BEGIN);
        if (ret != null) {
            return (Boolean)ret;
        }
        return false;
    }

    public static Annotation[] getAnnotationsArrayValue(Annotation annotation) {
        Object value = AnnotationUtils.getAnnotationValue(annotation);
        if (value != null && value.getClass().isArray() && Annotation.class.isAssignableFrom(value.getClass().getComponentType())) {
            return (Annotation[])value;
        }
        return null;
    }

    private static Object invokeAnnotationMethod(Annotation annotation, String method) {
        try {
            return MethodUtils.invokeExactMethod((Object)annotation, (String)method, null);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

