/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import java.util.Map;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.ExpressionLanguage;

public abstract class AbstractExpressionLanguage
implements ExpressionLanguage {
    @Override
    public boolean evaluateAsBoolean(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        Object result;
        block17: {
            result = this.evaluate(expression, values);
            if (result == null) {
                return false;
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            if (result instanceof Number) {
                return ((Number)result).doubleValue() != 0.0;
            }
            if (!(result instanceof CharSequence)) break block17;
            CharSequence seq = (CharSequence)result;
            if (seq.length() == 0) {
                return false;
            }
            if (seq.length() == 1) {
                char ch = seq.charAt(0);
                if (ch == '0') {
                    return false;
                }
                if (ch == '1') {
                    return true;
                }
            }
            switch (seq.toString().toLowerCase()) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
        }
        throw new ExpressionEvaluationException("The script [" + expression + "] must return a boolean value but returned [" + result + "]");
    }
}

