/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi.host;

import com.opensymphony.xwork2.config.ConfigurationException;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.felix.framework.Felix;
import org.apache.felix.main.AutoProcessor;
import org.apache.felix.main.Main;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.osgi.OsgiUtil;
import org.apache.struts2.osgi.host.BaseOsgiHost;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FelixOsgiHost
extends BaseOsgiHost {
    private static final Logger LOG = LogManager.getLogger(FelixOsgiHost.class);
    protected static final String FELIX_JRE_DETECT_JAVA_SPECIFICATION_VERSION = "${jre-${felix.detect.java.specification.version}}";
    protected static final String FELIX_JRE_DETECT_JPMS = "${jre-${felix.detect.jpms}}";
    protected static final String FELIX_DETECT_JAVA_VERSION = "${felix.detect.java.version}";
    protected static final String FELIX_JRE_BASE_PREFIX = "${jre-base";
    protected static final String FELIX_JRE_BASE_SUFFIX = "}";
    protected static final String OSGI_FRAMEWORK_SYSTEM_CAPABILITIES = "org.osgi.framework.system.capabilities";
    protected static final String OSGI_FRAMEWORK_EXECUTIONENVIRONMENT = "org.osgi.framework.executionenvironment";
    protected static final String FELIX_SERVICE_CAPS_KEY = "felix.service.caps";
    protected static final String FELIX_SERVICE_CAPS = "${felix.service.caps}";
    protected static final String FELIX_EE_CAP_JAVA_SPECIFICATION_VERSION = "${eecap-${java.specification.version}}";
    protected static final String FELIX_EE_CAP_DETECT_JPMS = "${eecap-${felix.detect.jpms}}";
    protected static final String FELIX_EE_JAVA_SPECIFICATION_VERSION = "${ee-${java.specification.version}}";
    protected static final String FELIX_EE_FELIX_DETECT_JPMS = "${ee-${felix.detect.jpms}}";
    protected Felix felix;

    protected void startFelix() {
        String felixPropertiesPath = this.getServletContextParam("struts.osgi.felixPropertiesPath", "default.properties");
        if ((felixPropertiesPath = felixPropertiesPath.trim()).startsWith("/")) {
            felixPropertiesPath = felixPropertiesPath.substring(1);
        }
        Properties configProps = this.getProperties(felixPropertiesPath);
        Main.copySystemProperties((Map)configProps);
        this.replaceSystemPackages(configProps);
        LOG.debug("Felix framework system capabilities: [{}]", (Object)configProps.getProperty(OSGI_FRAMEWORK_SYSTEM_CAPABILITIES));
        LOG.debug("Felix framework execution environment: [{}]", (Object)configProps.getProperty(OSGI_FRAMEWORK_EXECUTIONENVIRONMENT));
        LOG.debug("Felix service caps: [{}]", (Object)configProps.getProperty(FELIX_SERVICE_CAPS_KEY));
        this.replaceFelixSystemPackages(configProps);
        this.replaceFelixFrameworkSystemCapabilities(configProps);
        this.replaceFelixExecutionEnvironment(configProps);
        String strutsOSGiPropertiesPath = this.getServletContextParam("struts.osgi.strutsOSGiPropertiesPath", "struts-osgi.properties");
        strutsOSGiPropertiesPath = strutsOSGiPropertiesPath.trim();
        if (strutsOSGiPropertiesPath.startsWith("/")) {
            strutsOSGiPropertiesPath = strutsOSGiPropertiesPath.substring(1);
        }
        LOG.trace("FelixOSGiHost: Before addExportedPackages");
        Properties strutsConfigProps = this.getProperties(strutsOSGiPropertiesPath);
        try {
            this.addExportedPackages(strutsConfigProps, configProps);
        }
        catch (Throwable t) {
            throw new ConfigurationException("FelixOSGiHost couldn't start Apache Felix", t);
        }
        LOG.trace("FelixOSGiHost: After addExportedPackages, before addAutoStartBundles");
        try {
            this.addAutoStartBundles(configProps);
        }
        catch (Throwable t) {
            throw new ConfigurationException("FelixOSGiHost couldn't start Apache Felix", t);
        }
        LOG.trace("FelixOSGiHost: After addAutoStartBundles. before bundle cache processing");
        String storageDir = configProps.getProperty("org.osgi.framework.storage");
        if (storageDir == null || storageDir.isEmpty()) {
            String javaTmpDir = System.getProperty("java.io.tmpdir");
            if (javaTmpDir == null || javaTmpDir.isEmpty()) {
                LOG.warn("Felix environment 'java.io.tmpdir': [{}], and 'org.osgi.framework.storage': [{}].  Felix bundle cache will be created at the root directory (probable failure)", (Object)javaTmpDir, (Object)storageDir);
                javaTmpDir = File.separator;
            }
            storageDir = javaTmpDir.endsWith(File.separator) ? javaTmpDir + ".felix-cache" : javaTmpDir + File.separator + ".felix-cache";
            configProps.setProperty("org.osgi.framework.storage", storageDir);
        }
        LOG.debug("Storing bundles at [{}]", (Object)storageDir);
        String cleanBundleCache = this.getServletContextParam("struts.osgi.clearBundleCache", "true");
        if ("true".equalsIgnoreCase(cleanBundleCache)) {
            LOG.debug("Clearing bundle cache");
            configProps.put("org.osgi.framework.storage.clean", "onFirstInit");
        }
        String cacheLocking = this.getServletContextParam("struts.osgi.felixCacheLocking", "true");
        configProps.put("felix.cache.locking", cacheLocking);
        LOG.debug("Felix bundle cache locking: [{}]", (Object)cacheLocking);
        LOG.trace("FelixOSGiHost: After bundle cache processing, before configProps and init");
        configProps.put("felix.service.urlhandlers", "false");
        configProps.put("felix.log.level", this.getServletContextParam("struts.osgi.logLevel", "1"));
        configProps.put("Bundle-ClassPath", ".");
        configProps.put("org.osgi.framework.startlevel.beginning", this.getServletContextParam("struts.osgi.runLevel", "3"));
        try {
            this.felix = new Felix((Map)configProps);
            LOG.trace("FelixOSGiHost: After Felix construct. before init");
            this.felix.init();
            LOG.trace("FelixOSGiHost: After Felix init. before AutoProcessor process");
            AutoProcessor.process((Map)configProps, (BundleContext)this.felix.getBundleContext());
            LOG.trace("FelixOSGiHost: After Felix AutoProcessor process, before start");
            this.felix.start();
            LOG.trace("FelixOSGiHost: After Felix start");
            if (LOG.isDebugEnabled()) {
                Object[] serviceReferences = this.felix.getRegisteredServices();
                LOG.debug("Felix registered service references: [{}]", (Object)Arrays.toString(serviceReferences));
                serviceReferences = this.felix.getServicesInUse();
                LOG.debug("Felix in-use service references: [{}]", (Object)Arrays.toString(serviceReferences));
                Map<String, Bundle> bundleMap = this.getBundles();
                LOG.debug("Felix bundle map has size: [{}]", (Object)bundleMap.size());
                Set<String> bundleKeys = bundleMap.keySet();
                for (String currentKey : bundleKeys) {
                    Bundle currentBundle = bundleMap.get(currentKey);
                    if (currentBundle != null) {
                        Object[] bundleRegisteredServices = currentBundle.getRegisteredServices();
                        Object[] bundleServicesInUse = currentBundle.getServicesInUse();
                        LOG.debug("    Key: [{}], SymbolicName: [{}], Location: [{}], BundleID: [{}], State: [{}]", (Object)currentKey, (Object)currentBundle.getSymbolicName(), (Object)currentBundle.getLocation(), (Object)currentBundle.getBundleId(), (Object)currentBundle.getState());
                        LOG.debug("        Bundle Registered Services: [{}]", (Object)Arrays.toString(bundleRegisteredServices));
                        LOG.debug("        Bundle Services In Use: [{}]", (Object)Arrays.toString(bundleServicesInUse));
                        continue;
                    }
                    LOG.debug("    Key: [{}] returned a null bundle", (Object)currentKey);
                }
                Bundle[] bundles = this.getBundleContext().getBundles();
                if (bundles != null) {
                    LOG.debug("BundleContext bundle array has size: [{}]", (Object)bundles.length);
                    for (int index = 0; index < bundles.length; ++index) {
                        Bundle currentBundle = bundles[index];
                        if (currentBundle != null) {
                            LOG.debug("    Bundle [{}], SymbolicName: [{}], Location: [{}], BundleID: [{}], State: [{}]", (Object)index, (Object)currentBundle.getSymbolicName(), (Object)currentBundle.getLocation(), (Object)currentBundle.getBundleId(), (Object)currentBundle.getState());
                            continue;
                        }
                        LOG.debug("    Bundle [{}] is null", (Object)index);
                    }
                } else {
                    LOG.debug("Default Bundle Context bundle array is null");
                }
            }
            LOG.trace("Apache Felix is running");
        }
        catch (Throwable t) {
            throw new ConfigurationException("FelixOSGiHost couldn't start Apache Felix", t);
        }
        this.addSpringOSGiSupport();
        this.servletContext.setAttribute("__struts_osgi_bundle_context", (Object)this.felix.getBundleContext());
    }

    @Override
    public void init(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.startFelix();
    }

    @Override
    public Map<String, Bundle> getBundles() {
        if (this.felix == null) {
            throw new IllegalStateException("Felix reference is null (never started or initialized)");
        }
        HashMap<String, Bundle> bundles = new HashMap<String, Bundle>();
        for (Bundle bundle : this.felix.getBundleContext().getBundles()) {
            bundles.put(bundle.getSymbolicName(), bundle);
        }
        return Collections.unmodifiableMap(bundles);
    }

    @Override
    public Map<String, Bundle> getActiveBundles() {
        if (this.felix == null) {
            throw new IllegalStateException("Felix reference is null (never started or initialized)");
        }
        HashMap<String, Bundle> bundles = new HashMap<String, Bundle>();
        for (Bundle bundle : this.felix.getBundleContext().getBundles()) {
            if (bundle.getState() != 32) continue;
            bundles.put(bundle.getSymbolicName(), bundle);
        }
        return Collections.unmodifiableMap(bundles);
    }

    @Override
    public BundleContext getBundleContext() {
        if (this.felix == null) {
            throw new IllegalStateException("Felix reference is null (never started or initialized)");
        }
        return this.felix.getBundleContext();
    }

    @Override
    public void destroy() throws Exception {
        if (this.felix == null) {
            throw new IllegalStateException("Felix reference is null (never started or initialized)");
        }
        try {
            this.felix.stop();
            LOG.trace("Apache Felix has stopped");
        }
        catch (Throwable t) {
            LOG.error("FelixOSGiHost stop failure", t);
            throw t;
        }
    }

    @Override
    protected void addSpringOSGiSupport() {
        try {
            Class<?> clazz = Class.forName("org.springframework.osgi.web.context.support.OsgiBundleXmlWebApplicationContext");
            String key = (String)clazz.getDeclaredField("BUNDLE_CONTEXT_ATTRIBUTE").get(null);
            if (this.felix == null) {
                throw new IllegalStateException("Felix reference is null (never started or initialized)");
            }
            this.servletContext.setAttribute(key, (Object)this.felix.getBundleContext());
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Spring OSGi support is not enabled");
            }
        }
        catch (Exception e) {
            LOG.error("The API of Spring OSGi has changed and the field [{}] is no longer available. The OSGi plugin needs to be updated", (Object)"org.springframework.osgi.web.context.support.OsgiBundleXmlWebApplicationContext.BUNDLE_CONTEXT_ATTRIBUTE", (Object)e);
        }
    }

    protected void replaceFelixSystemPackages(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Cannot replace Felix system packages given a null properties reference");
        }
        String systemPackages = (String)properties.get("org.osgi.framework.system.packages");
        if (systemPackages != null && !systemPackages.isEmpty()) {
            LOG.debug("OSGi System Packages (before replacement): [{}]", (Object)systemPackages);
            String systemJavaVersion = System.getProperty("java.version");
            if (systemJavaVersion != null && !systemJavaVersion.isEmpty()) {
                String jreJavaSpecificationVersion = "jre-" + OsgiUtil.generateJavaVersionForSystemPackages(systemJavaVersion);
                LOG.debug("  System java.version: [{}], generated Java Specification Version: [{}]", (Object)systemJavaVersion, (Object)jreJavaSpecificationVersion);
                String jreJavaSpecificationVersionSubstitution = (String)properties.get(jreJavaSpecificationVersion);
                if (jreJavaSpecificationVersionSubstitution != null && !jreJavaSpecificationVersionSubstitution.isEmpty()) {
                    jreJavaSpecificationVersionSubstitution = this.expandAllFelixJREBaseElements(jreJavaSpecificationVersionSubstitution, properties);
                    boolean constainsFelix_JRE_Java_Specification_Version = systemPackages.contains(FELIX_JRE_DETECT_JAVA_SPECIFICATION_VERSION);
                    boolean constainsFelix_JRE_JPMS = systemPackages.contains(FELIX_JRE_DETECT_JPMS);
                    jreJavaSpecificationVersionSubstitution = jreJavaSpecificationVersionSubstitution.replace(FELIX_DETECT_JAVA_VERSION, OsgiUtil.generateJava_SE_SystemPackageVersionString(systemJavaVersion)).trim();
                    if (constainsFelix_JRE_Java_Specification_Version && constainsFelix_JRE_JPMS) {
                        systemPackages = systemPackages.replace(FELIX_JRE_DETECT_JAVA_SPECIFICATION_VERSION, jreJavaSpecificationVersionSubstitution);
                        systemPackages = systemPackages.replace(FELIX_JRE_DETECT_JPMS, "").trim();
                    } else if (constainsFelix_JRE_Java_Specification_Version) {
                        systemPackages = systemPackages.replace(FELIX_JRE_DETECT_JAVA_SPECIFICATION_VERSION, jreJavaSpecificationVersionSubstitution);
                    } else if (constainsFelix_JRE_JPMS) {
                        systemPackages = systemPackages.replace(FELIX_JRE_DETECT_JPMS, jreJavaSpecificationVersionSubstitution);
                    } else {
                        LOG.warn("Properties property [{}] is present, but we are unable to replace Felix JRE system packages due to missing at least one of [{}] [{}] keys in the configuration.", (Object)jreJavaSpecificationVersion, (Object)FELIX_JRE_DETECT_JAVA_SPECIFICATION_VERSION, (Object)FELIX_JRE_DETECT_JPMS);
                    }
                    properties.put("org.osgi.framework.system.packages", systemPackages);
                } else {
                    LOG.warn("Properties property [{}] is null or empty.  Unable to replace Felix JRE system packages.  Felix JRE system packages will be cleared.", (Object)jreJavaSpecificationVersion);
                    systemPackages = systemPackages.replace(FELIX_JRE_DETECT_JAVA_SPECIFICATION_VERSION, "");
                    systemPackages = systemPackages.replace(FELIX_JRE_DETECT_JPMS, "").trim();
                    properties.put("org.osgi.framework.system.packages", systemPackages);
                }
            } else {
                LOG.warn("System property [{}] is null or empty.  Unable to replace Felix JRE system packages.", (Object)"java.version");
            }
            LOG.debug("OSGi System Packages (after replacement): [{}]", (Object)systemPackages);
        } else {
            LOG.warn("Unable to replace Felix JRE system packages.  Properties required key [{}] is missing or empty.", (Object)"org.osgi.framework.system.packages");
        }
    }

    protected void replaceFelixFrameworkSystemCapabilities(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Cannot replace Felix system capabilities given a null properties reference");
        }
        String systemCapabilities = (String)properties.get(OSGI_FRAMEWORK_SYSTEM_CAPABILITIES);
        if (systemCapabilities != null && !systemCapabilities.isEmpty()) {
            LOG.debug("OSGi System Capabilities (before replacement): [{}]", (Object)systemCapabilities);
            systemCapabilities = this.expandAllOsgiFrameworkSystemCapabilities(systemCapabilities, properties);
            properties.put(OSGI_FRAMEWORK_SYSTEM_CAPABILITIES, systemCapabilities);
            LOG.debug("OSGi System Capabilities (after replacement): [{}]", (Object)systemCapabilities);
        } else {
            LOG.warn("Unable to replace Felix system capabilities.  Properties required key [{}] is missing or empty", (Object)OSGI_FRAMEWORK_SYSTEM_CAPABILITIES);
        }
    }

    protected void replaceFelixExecutionEnvironment(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Cannot replace Felix execution environment given a null properties reference");
        }
        String executionEnvironment = (String)properties.get(OSGI_FRAMEWORK_EXECUTIONENVIRONMENT);
        if (executionEnvironment != null && !executionEnvironment.isEmpty()) {
            LOG.debug("OSGi Execution Environment (before replacement): [{}]", (Object)executionEnvironment);
            executionEnvironment = this.expandAllOsgiFrameworkExecutionEnvironments(executionEnvironment, properties);
            properties.put(OSGI_FRAMEWORK_EXECUTIONENVIRONMENT, executionEnvironment);
            LOG.debug("OSGi Execution Environment (after replacement): [{}]", (Object)executionEnvironment);
        } else {
            LOG.warn("Unable to replace Felix execution environment.  Properties required key [{}] is missing or empty", (Object)OSGI_FRAMEWORK_EXECUTIONENVIRONMENT);
        }
    }

    protected String expandAllFelixJREBaseElements(String jreProperty, Properties properties) {
        String result = jreProperty;
        if (properties == null) {
            throw new IllegalArgumentException("Cannot expand Felix JRE base elements given a null properties reference");
        }
        if (jreProperty != null && !jreProperty.isEmpty()) {
            int nextBaseEnd;
            int nextBaseStart = jreProperty.indexOf(FELIX_JRE_BASE_PREFIX);
            int n = nextBaseEnd = nextBaseStart != -1 ? jreProperty.indexOf(FELIX_JRE_BASE_SUFFIX, nextBaseStart + FELIX_JRE_BASE_PREFIX.length()) : -1;
            if (nextBaseStart != -1 && nextBaseEnd != -1) {
                String jreBaseReplace = jreProperty.substring(nextBaseStart, nextBaseEnd + 1);
                String jreBaseLookup = jreBaseReplace.substring(2, jreBaseReplace.length() - 1);
                String jreBaseSubstitution = (String)properties.get(jreBaseLookup);
                LOG.trace("    JRE Base elements - Result so far [{}], current replace[{}], current lookup [{}], current substitution [{}]", (Object)jreProperty, (Object)jreBaseReplace, (Object)jreBaseLookup, (Object)jreBaseSubstitution);
                if (jreBaseSubstitution == null || jreBaseSubstitution.isEmpty()) {
                    LOG.warn("Unable to expand Felix JRE base property [{}] as it is missing or empty.  Replacing with empty string", (Object)jreBaseLookup);
                    jreBaseSubstitution = "";
                } else {
                    jreBaseSubstitution = jreBaseSubstitution.trim();
                }
                result = this.expandAllFelixJREBaseElements(jreProperty.replace(jreBaseReplace, jreBaseSubstitution), properties);
            }
        } else {
            LOG.warn("Unable to expand Felix JRE base elements.  Base property [{}] is missing or empty", (Object)jreProperty);
        }
        return result;
    }

    protected String expandAllOsgiFrameworkSystemCapabilities(String capabilities, Properties properties) {
        String result = capabilities;
        if (properties == null) {
            throw new IllegalArgumentException("Cannot expand OSGi framework system capabilities elements given a null properties reference");
        }
        if (capabilities != null && !capabilities.isEmpty()) {
            String systemJavaVersion = System.getProperty("java.version");
            String eeCapJavaSpecificationVersion = null;
            String eeCapJavaSpecificationVersionSubstitution = null;
            boolean constains_Felix_Service_Caps = capabilities.contains(FELIX_SERVICE_CAPS);
            boolean constains_Felix_EE_Cap_Java_Specification_Version = capabilities.contains(FELIX_EE_CAP_JAVA_SPECIFICATION_VERSION);
            boolean constains_Felix_EE_Cap_Detect_JPMS = capabilities.contains(FELIX_EE_CAP_DETECT_JPMS);
            if (systemJavaVersion != null && !systemJavaVersion.isEmpty()) {
                eeCapJavaSpecificationVersion = "eecap-" + OsgiUtil.generateJavaVersionForSystemPackages(systemJavaVersion);
                LOG.debug("  System java.version: [{}], generated EE Capabilities Java Specification Version: [{}]", (Object)systemJavaVersion, (Object)eeCapJavaSpecificationVersion);
                eeCapJavaSpecificationVersionSubstitution = properties.getProperty(eeCapJavaSpecificationVersion);
                if (eeCapJavaSpecificationVersionSubstitution == null || eeCapJavaSpecificationVersionSubstitution.isEmpty()) {
                    LOG.warn("System property [{}] is null or empty.  Unable to replace Felix EE capabilities.  Replacing with empty string", (Object)eeCapJavaSpecificationVersion);
                    eeCapJavaSpecificationVersionSubstitution = "";
                } else {
                    eeCapJavaSpecificationVersionSubstitution = eeCapJavaSpecificationVersionSubstitution.trim();
                }
            } else {
                LOG.warn("System property [{}] is null or empty.  Unable to replace Felix EE capabilities.", (Object)"java.version");
            }
            if (constains_Felix_Service_Caps) {
                String felixServiceCapsSubstitution = properties.getProperty(FELIX_SERVICE_CAPS_KEY);
                if (felixServiceCapsSubstitution == null || felixServiceCapsSubstitution.isEmpty()) {
                    LOG.warn("System property [{}] is null or empty.  Unable to replace Felix service capabilities.  Replacing with empty string", (Object)FELIX_SERVICE_CAPS_KEY);
                    felixServiceCapsSubstitution = "";
                } else {
                    felixServiceCapsSubstitution = felixServiceCapsSubstitution.trim();
                }
                result = result.replace(FELIX_SERVICE_CAPS, felixServiceCapsSubstitution);
            }
            if (constains_Felix_EE_Cap_Java_Specification_Version && constains_Felix_EE_Cap_Detect_JPMS) {
                result = result.replace(FELIX_EE_CAP_JAVA_SPECIFICATION_VERSION, eeCapJavaSpecificationVersionSubstitution);
                result = result.replace(FELIX_EE_CAP_DETECT_JPMS, "").trim();
            } else if (constains_Felix_EE_Cap_Java_Specification_Version) {
                result = result.replace(FELIX_EE_CAP_JAVA_SPECIFICATION_VERSION, eeCapJavaSpecificationVersionSubstitution);
            } else if (constains_Felix_EE_Cap_Detect_JPMS) {
                result = result.replace(FELIX_EE_CAP_DETECT_JPMS, eeCapJavaSpecificationVersionSubstitution);
            } else {
                LOG.warn("Properties property [{}] is present, but we are unable to replace Felix EE capabilities due to missing at least one of [{}] [{}] keys in the configuration", (Object)eeCapJavaSpecificationVersion, (Object)FELIX_EE_CAP_JAVA_SPECIFICATION_VERSION, (Object)FELIX_EE_CAP_DETECT_JPMS);
            }
        } else {
            LOG.warn("Unable to expand OSGi framework system capabilities elements.  Capability parameter [{}] is missing or empty", (Object)capabilities);
        }
        return result;
    }

    protected String expandAllOsgiFrameworkExecutionEnvironments(String executionEnvironment, Properties properties) {
        String result = executionEnvironment;
        if (properties == null) {
            throw new IllegalArgumentException("Cannot expand OSGi framework execution environment elements given a null properties reference");
        }
        if (executionEnvironment != null && !executionEnvironment.isEmpty()) {
            String systemJavaVersion = System.getProperty("java.version");
            String eeJavaSpecificationVersion = null;
            String eeJavaSpecificationVersionSubstitution = null;
            boolean constains_Felix_EE_Java_Specification_Version = executionEnvironment.contains(FELIX_EE_JAVA_SPECIFICATION_VERSION);
            boolean constains_Felix_EE_Felix_Detect_JPMS = executionEnvironment.contains(FELIX_EE_FELIX_DETECT_JPMS);
            if (systemJavaVersion != null && !systemJavaVersion.isEmpty()) {
                eeJavaSpecificationVersion = "ee-" + OsgiUtil.generateJavaVersionForSystemPackages(systemJavaVersion);
                LOG.debug("  System java.version: [{}], generated EE Java Specification Version: [{}]", (Object)systemJavaVersion, (Object)eeJavaSpecificationVersion);
                eeJavaSpecificationVersionSubstitution = properties.getProperty(eeJavaSpecificationVersion);
                if (eeJavaSpecificationVersionSubstitution == null || eeJavaSpecificationVersionSubstitution.isEmpty()) {
                    LOG.warn("System property [{}] is null or empty.  Unable to replace Felix EE execution environment.  Replacing with empty string", (Object)eeJavaSpecificationVersion);
                    eeJavaSpecificationVersionSubstitution = "";
                } else {
                    eeJavaSpecificationVersionSubstitution = eeJavaSpecificationVersionSubstitution.trim();
                }
            } else {
                LOG.warn("System property [{}] is null or empty.  Unable to replace Felix EE execution environment", (Object)"java.version");
            }
            if (constains_Felix_EE_Java_Specification_Version && constains_Felix_EE_Felix_Detect_JPMS) {
                result = result.replace(FELIX_EE_JAVA_SPECIFICATION_VERSION, eeJavaSpecificationVersionSubstitution);
                result = result.replace(FELIX_EE_FELIX_DETECT_JPMS, "").trim();
            } else if (constains_Felix_EE_Java_Specification_Version) {
                result = result.replace(FELIX_EE_JAVA_SPECIFICATION_VERSION, eeJavaSpecificationVersionSubstitution);
            } else if (constains_Felix_EE_Felix_Detect_JPMS) {
                result = result.replace(FELIX_EE_FELIX_DETECT_JPMS, eeJavaSpecificationVersionSubstitution);
            } else {
                LOG.warn("Properties property [{}] is present, but we are unable to replace Felix EE execution environment due to missing at least one of [{}] [{}] keys in the configuration", (Object)eeJavaSpecificationVersion, (Object)FELIX_EE_JAVA_SPECIFICATION_VERSION, (Object)FELIX_EE_FELIX_DETECT_JPMS);
            }
        } else {
            LOG.warn("Unable to expand OSGi framework execution environment elements.  Execution environment parameter [{}] is missing or empty", (Object)executionEnvironment);
        }
        return result;
    }
}

