/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.template;

import java.io.IOException;
import java.util.Deque;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tiles.api.Attribute;
import org.apache.tiles.api.TilesContainer;
import org.apache.tiles.api.access.TilesAccess;
import org.apache.tiles.autotag.core.runtime.ModelBody;
import org.apache.tiles.request.Request;
import org.apache.tiles.template.AttributeResolver;
import org.apache.tiles.template.ComposeStackUtil;
import org.apache.tiles.template.DefaultAttributeResolver;

public class InsertAttributeModel {
    private static final Logger LOG = LogManager.getLogger(InsertAttributeModel.class);
    private final AttributeResolver attributeResolver;

    public InsertAttributeModel() {
        this(new DefaultAttributeResolver());
    }

    public InsertAttributeModel(AttributeResolver attributeResolver) {
        this.attributeResolver = attributeResolver;
    }

    public void execute(boolean ignore, String preparer, String role, Object defaultValue, String defaultValueRole, String defaultValueType, String name, Attribute value, boolean flush, Request request, ModelBody modelBody) throws IOException {
        TilesContainer container = TilesAccess.getCurrentContainer(request);
        Deque<Object> composeStack = ComposeStackUtil.getComposeStack(request);
        Attribute attribute = this.resolveAttribute(container, ignore, preparer, role, defaultValue, defaultValueRole, defaultValueType, name, value, request);
        if (attribute != null) {
            composeStack.push(attribute);
        }
        modelBody.evaluateWithoutWriting();
        container = TilesAccess.getCurrentContainer(request);
        if (attribute != null) {
            attribute = (Attribute)composeStack.pop();
        }
        this.renderAttribute(container, ignore, attribute, request);
        if (flush) {
            request.getWriter().flush();
        }
    }

    private Attribute resolveAttribute(TilesContainer container, boolean ignore, String preparer, String role, Object defaultValue, String defaultValueRole, String defaultValueType, String name, Attribute value, Request request) {
        if (preparer != null) {
            container.prepare(preparer, request);
        }
        Attribute attribute = this.attributeResolver.computeAttribute(container, value, name, role, ignore, defaultValue, defaultValueRole, defaultValueType, request);
        container.startContext(request);
        return attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderAttribute(TilesContainer container, boolean ignore, Attribute attribute, Request request) throws IOException {
        try {
            if (attribute == null && ignore) {
                return;
            }
            container.render(attribute, request);
        }
        catch (IOException | RuntimeException e) {
            if (!ignore) {
                throw e;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring exception", (Throwable)e);
            }
        }
        finally {
            container.endContext(request);
        }
    }
}

