/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.autotag.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tiles.autotag.model.TemplateMethod;
import org.apache.tiles.autotag.model.TemplateParameter;

public class TemplateClass {
    private String name;
    private String tagName;
    private String tagClassPrefix;
    private String documentation;
    private TemplateMethod executeMethod;

    public TemplateClass(String name) {
        this(name, null, null, null);
    }

    public TemplateClass(String name, String tagName, String tagClassPrefix, TemplateMethod executeMethod) {
        this.name = name;
        this.tagName = tagName;
        this.tagClassPrefix = tagClassPrefix;
        this.executeMethod = executeMethod;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        int pos = this.name.lastIndexOf(46);
        if (pos >= 0) {
            return this.name.substring(pos + 1);
        }
        return this.name;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getTagClassPrefix() {
        return this.tagClassPrefix;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public TemplateMethod getExecuteMethod() {
        return this.executeMethod;
    }

    public Collection<TemplateParameter> getParameters() {
        LinkedHashMap<String, TemplateParameter> params = new LinkedHashMap<String, TemplateParameter>();
        this.fillRegularParameters(params, this.executeMethod);
        return params.values();
    }

    public boolean hasBody() {
        return this.executeMethod.hasBody();
    }

    public String toString() {
        return "TemplateClass [name=" + this.name + ", tagName=" + this.tagName + ", tagClassPrefix=" + this.tagClassPrefix + ", documentation=" + this.documentation + ", executeMethod=" + this.executeMethod + "]";
    }

    private void fillRegularParameters(Map<String, TemplateParameter> params, TemplateMethod method) {
        if (method != null) {
            for (TemplateParameter param : method.getParameters()) {
                if (param.isRequest() || param.isBody()) continue;
                params.put(param.getName(), param);
            }
        }
    }
}

