/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.event;

import org.directwebremoting.ConversionException;
import org.directwebremoting.Hub;
import org.directwebremoting.event.MessageEvent;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.RealRawData;

public class DefaultMessageEvent
implements MessageEvent {
    private Hub hub;
    private Object data;
    private RealRawData rawData;
    private Source source;
    private ConverterManager converterManager;

    public DefaultMessageEvent(Hub hub, Object data) {
        this.hub = hub;
        this.data = data;
        this.source = Source.SERVER;
    }

    public DefaultMessageEvent(Hub hub, ConverterManager converterManager, RealRawData rawData) {
        this.hub = hub;
        this.converterManager = converterManager;
        this.rawData = rawData;
        this.source = Source.INTERNET;
    }

    @Override
    public Hub getHub() {
        return this.hub;
    }

    @Override
    public <T> T getData(Class<T> asType) {
        if (this.source == Source.SERVER) {
            try {
                return (T)this.data;
            }
            catch (ClassCastException ex) {
                throw new ConversionException(asType, (Throwable)ex);
            }
        }
        return this.converterManager.convertInbound(asType, this.rawData);
    }

    @Override
    public Object getRawData() {
        if (this.source == Source.SERVER) {
            return this.data;
        }
        return this.rawData;
    }

    private static enum Source {
        SERVER,
        INTERNET;

    }
}

