/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.test.context.BootstrapUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class TestContextManager {
    private static final Log logger = LogFactory.getLog(TestContextManager.class);
    private final TestContext testContext;
    private final ThreadLocal<TestContext> testContextHolder = ThreadLocal.withInitial(new Supplier<TestContext>(){

        @Override
        public TestContext get() {
            return TestContextManager.copyTestContext(TestContextManager.this.testContext);
        }
    });
    private final List<TestExecutionListener> testExecutionListeners = new ArrayList<TestExecutionListener>();

    public TestContextManager(Class<?> testClass) {
        this(BootstrapUtils.resolveTestContextBootstrapper(BootstrapUtils.createBootstrapContext(testClass)));
    }

    public TestContextManager(TestContextBootstrapper testContextBootstrapper) {
        this.testContext = testContextBootstrapper.buildTestContext();
        this.registerTestExecutionListeners(testContextBootstrapper.getTestExecutionListeners());
    }

    public final TestContext getTestContext() {
        return this.testContextHolder.get();
    }

    public void registerTestExecutionListeners(List<TestExecutionListener> testExecutionListeners) {
        this.registerTestExecutionListeners(testExecutionListeners.toArray(new TestExecutionListener[0]));
    }

    public void registerTestExecutionListeners(TestExecutionListener ... testExecutionListeners) {
        for (TestExecutionListener listener : testExecutionListeners) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Registering TestExecutionListener: " + listener));
            }
            this.testExecutionListeners.add(listener);
        }
    }

    public final List<TestExecutionListener> getTestExecutionListeners() {
        return this.testExecutionListeners;
    }

    private List<TestExecutionListener> getReversedTestExecutionListeners() {
        ArrayList<TestExecutionListener> listenersReversed = new ArrayList<TestExecutionListener>(this.getTestExecutionListeners());
        Collections.reverse(listenersReversed);
        return listenersReversed;
    }

    public void beforeTestClass() throws Exception {
        Class<?> testClass = this.getTestContext().getTestClass();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("beforeTestClass(): class [" + testClass.getName() + "]"));
        }
        this.getTestContext().updateState(null, null, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.beforeTestClass(this.getTestContext());
            }
            catch (Throwable ex) {
                this.logException(ex, "beforeTestClass", testExecutionListener, testClass);
                ReflectionUtils.rethrowException((Throwable)ex);
            }
        }
    }

    public void prepareTestInstance(Object testInstance) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("prepareTestInstance(): instance [" + testInstance + "]"));
        }
        this.getTestContext().updateState(testInstance, null, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.prepareTestInstance(this.getTestContext());
            }
            catch (Throwable ex) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to prepare test instance [" + testInstance + "]"), ex);
                }
                ReflectionUtils.rethrowException((Throwable)ex);
            }
        }
    }

    public void beforeTestMethod(Object testInstance, Method testMethod) throws Exception {
        String callbackName = "beforeTestMethod";
        this.prepareForBeforeCallback(callbackName, testInstance, testMethod);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.beforeTestMethod(this.getTestContext());
            }
            catch (Throwable ex) {
                this.handleBeforeException(ex, callbackName, testExecutionListener, testInstance, testMethod);
            }
        }
    }

    public void beforeTestExecution(Object testInstance, Method testMethod) throws Exception {
        String callbackName = "beforeTestExecution";
        this.prepareForBeforeCallback(callbackName, testInstance, testMethod);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.beforeTestExecution(this.getTestContext());
            }
            catch (Throwable ex) {
                this.handleBeforeException(ex, callbackName, testExecutionListener, testInstance, testMethod);
            }
        }
    }

    public void afterTestExecution(Object testInstance, Method testMethod, @Nullable Throwable exception) throws Exception {
        String callbackName = "afterTestExecution";
        this.prepareForAfterCallback(callbackName, testInstance, testMethod, exception);
        Throwable afterTestExecutionException = null;
        for (TestExecutionListener testExecutionListener : this.getReversedTestExecutionListeners()) {
            try {
                testExecutionListener.afterTestExecution(this.getTestContext());
            }
            catch (Throwable ex) {
                this.logException(ex, callbackName, testExecutionListener, testInstance, testMethod);
                if (afterTestExecutionException == null) {
                    afterTestExecutionException = ex;
                    continue;
                }
                afterTestExecutionException.addSuppressed(ex);
            }
        }
        if (afterTestExecutionException != null) {
            ReflectionUtils.rethrowException(afterTestExecutionException);
        }
    }

    public void afterTestMethod(Object testInstance, Method testMethod, @Nullable Throwable exception) throws Exception {
        String callbackName = "afterTestMethod";
        this.prepareForAfterCallback(callbackName, testInstance, testMethod, exception);
        Throwable afterTestMethodException = null;
        for (TestExecutionListener testExecutionListener : this.getReversedTestExecutionListeners()) {
            try {
                testExecutionListener.afterTestMethod(this.getTestContext());
            }
            catch (Throwable ex) {
                this.logException(ex, callbackName, testExecutionListener, testInstance, testMethod);
                if (afterTestMethodException == null) {
                    afterTestMethodException = ex;
                    continue;
                }
                afterTestMethodException.addSuppressed(ex);
            }
        }
        if (afterTestMethodException != null) {
            ReflectionUtils.rethrowException(afterTestMethodException);
        }
    }

    public void afterTestClass() throws Exception {
        Class<?> testClass = this.getTestContext().getTestClass();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("afterTestClass(): class [" + testClass.getName() + "]"));
        }
        this.getTestContext().updateState(null, null, null);
        Throwable afterTestClassException = null;
        for (TestExecutionListener testExecutionListener : this.getReversedTestExecutionListeners()) {
            try {
                testExecutionListener.afterTestClass(this.getTestContext());
            }
            catch (Throwable ex) {
                this.logException(ex, "afterTestClass", testExecutionListener, testClass);
                if (afterTestClassException == null) {
                    afterTestClassException = ex;
                    continue;
                }
                afterTestClassException.addSuppressed(ex);
            }
        }
        this.testContextHolder.remove();
        if (afterTestClassException != null) {
            ReflectionUtils.rethrowException(afterTestClassException);
        }
    }

    private void prepareForBeforeCallback(String callbackName, Object testInstance, Method testMethod) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("%s(): instance [%s], method [%s]", callbackName, testInstance, testMethod));
        }
        this.getTestContext().updateState(testInstance, testMethod, null);
    }

    private void prepareForAfterCallback(String callbackName, Object testInstance, Method testMethod, @Nullable Throwable exception) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("%s(): instance [%s], method [%s], exception [%s]", callbackName, testInstance, testMethod, exception));
        }
        this.getTestContext().updateState(testInstance, testMethod, exception);
    }

    private void handleBeforeException(Throwable ex, String callbackName, TestExecutionListener testExecutionListener, Object testInstance, Method testMethod) throws Exception {
        this.logException(ex, callbackName, testExecutionListener, testInstance, testMethod);
        ReflectionUtils.rethrowException((Throwable)ex);
    }

    private void logException(Throwable ex, String callbackName, TestExecutionListener testExecutionListener, Class<?> testClass) {
        if (logger.isWarnEnabled()) {
            logger.warn((Object)String.format("Caught exception while invoking '%s' callback on TestExecutionListener [%s] for test class [%s]", callbackName, testExecutionListener, testClass), ex);
        }
    }

    private void logException(Throwable ex, String callbackName, TestExecutionListener testExecutionListener, Object testInstance, Method testMethod) {
        if (logger.isWarnEnabled()) {
            logger.warn((Object)String.format("Caught exception while invoking '%s' callback on TestExecutionListener [%s] for test method [%s] and test instance [%s]", callbackName, testExecutionListener, testMethod, testInstance), ex);
        }
    }

    private static TestContext copyTestContext(TestContext testContext) {
        block3: {
            Constructor constructor = ClassUtils.getConstructorIfAvailable(testContext.getClass(), (Class[])new Class[]{testContext.getClass()});
            if (constructor != null) {
                try {
                    ReflectionUtils.makeAccessible((Constructor)constructor);
                    return (TestContext)constructor.newInstance(testContext);
                }
                catch (Exception ex) {
                    if (!logger.isInfoEnabled()) break block3;
                    logger.info((Object)String.format("Failed to invoke copy constructor for [%s]; concurrent test execution is therefore likely not supported.", testContext), (Throwable)ex);
                }
            }
        }
        return testContext;
    }
}

