/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockAsyncContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.web.servlet.DefaultMvcResult;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.async.CallableProcessingInterceptor;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.DeferredResultProcessingInterceptor;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.WebUtils;

final class TestDispatcherServlet
extends DispatcherServlet {
    private static final String KEY = TestDispatcherServlet.class.getName() + ".interceptor";

    public TestDispatcherServlet(WebApplicationContext webApplicationContext) {
        super(webApplicationContext);
    }

    protected void service(HttpServletRequest request2, HttpServletResponse response) throws ServletException, IOException {
        this.registerAsyncResultInterceptors(request2);
        super.service(request2, response);
        if (request2.getAsyncContext() != null) {
            MockAsyncContext asyncContext;
            if (request2.getAsyncContext() instanceof MockAsyncContext) {
                asyncContext = (MockAsyncContext)request2.getAsyncContext();
            } else {
                MockHttpServletRequest mockRequest = (MockHttpServletRequest)WebUtils.getNativeRequest((ServletRequest)request2, MockHttpServletRequest.class);
                Assert.notNull((Object)mockRequest, (String)"Expected MockHttpServletRequest");
                asyncContext = (MockAsyncContext)mockRequest.getAsyncContext();
                String requestClassName = request2.getClass().getName();
                Assert.notNull((Object)asyncContext, () -> "Outer request wrapper " + requestClassName + " has an AsyncContext,but it is not a MockAsyncContext, while the nested " + mockRequest.getClass().getName() + " does not have an AsyncContext at all.");
            }
            CountDownLatch dispatchLatch = new CountDownLatch(1);
            asyncContext.addDispatchHandler(dispatchLatch::countDown);
            this.getMvcResult((ServletRequest)request2).setAsyncDispatchLatch(dispatchLatch);
        }
    }

    private void registerAsyncResultInterceptors(final HttpServletRequest request2) {
        WebAsyncUtils.getAsyncManager((ServletRequest)request2).registerCallableInterceptor((Object)KEY, new CallableProcessingInterceptor(){

            public <T> void postProcess(NativeWebRequest r, Callable<T> task, Object value) {
                TestDispatcherServlet.this.getMvcResult((ServletRequest)request2).setAsyncResult(value);
            }
        });
        WebAsyncUtils.getAsyncManager((ServletRequest)request2).registerDeferredResultInterceptor((Object)KEY, new DeferredResultProcessingInterceptor(){

            public <T> void postProcess(NativeWebRequest r, DeferredResult<T> result, Object value) {
                TestDispatcherServlet.this.getMvcResult((ServletRequest)request2).setAsyncResult(value);
            }
        });
    }

    protected DefaultMvcResult getMvcResult(ServletRequest request2) {
        return (DefaultMvcResult)request2.getAttribute(MockMvc.MVC_RESULT_ATTRIBUTE);
    }

    protected HandlerExecutionChain getHandler(HttpServletRequest request2) throws Exception {
        HandlerExecutionChain chain = super.getHandler(request2);
        if (chain != null) {
            DefaultMvcResult mvcResult = this.getMvcResult((ServletRequest)request2);
            mvcResult.setHandler(chain.getHandler());
            mvcResult.setInterceptors(chain.getInterceptors());
        }
        return chain;
    }

    protected void render(ModelAndView mv, HttpServletRequest request2, HttpServletResponse response) throws Exception {
        DefaultMvcResult mvcResult = this.getMvcResult((ServletRequest)request2);
        mvcResult.setModelAndView(mv);
        super.render(mv, request2, response);
    }

    protected ModelAndView processHandlerException(HttpServletRequest request2, HttpServletResponse response, @Nullable Object handler, Exception ex) throws Exception {
        ModelAndView mav = super.processHandlerException(request2, response, handler, ex);
        DefaultMvcResult mvcResult = this.getMvcResult((ServletRequest)request2);
        mvcResult.setResolvedException(ex);
        mvcResult.setModelAndView(mav);
        return mav;
    }
}

