/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4.rules;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit4.rules.SpringClassRule;
import org.springframework.test.context.junit4.statements.ProfileValueChecker;
import org.springframework.test.context.junit4.statements.RunAfterTestMethodCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestMethodCallbacks;
import org.springframework.test.context.junit4.statements.RunPrepareTestInstanceCallbacks;
import org.springframework.test.context.junit4.statements.SpringFailOnTimeout;
import org.springframework.test.context.junit4.statements.SpringRepeat;

public class SpringMethodRule
implements MethodRule {
    private static final Log logger = LogFactory.getLog(SpringMethodRule.class);

    public Statement apply(Statement base, FrameworkMethod frameworkMethod, Object testInstance) {
        Method testMethod = frameworkMethod.getMethod();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applying SpringMethodRule to test method [" + testMethod + "]"));
        }
        Class<?> testClass = testInstance.getClass();
        TestContextManager testContextManager = SpringClassRule.getTestContextManager(testClass);
        Statement statement = base;
        statement = this.withBeforeTestMethodCallbacks(statement, testMethod, testInstance, testContextManager);
        statement = this.withAfterTestMethodCallbacks(statement, testMethod, testInstance, testContextManager);
        statement = this.withTestInstancePreparation(statement, testInstance, testContextManager);
        statement = this.withPotentialRepeat(statement, testMethod, testInstance);
        statement = this.withPotentialTimeout(statement, testMethod, testInstance);
        statement = this.withProfileValueCheck(statement, testMethod, testInstance);
        return statement;
    }

    private Statement withBeforeTestMethodCallbacks(Statement next, Method testMethod, Object testInstance, TestContextManager testContextManager) {
        return new RunBeforeTestMethodCallbacks(next, testInstance, testMethod, testContextManager);
    }

    private Statement withAfterTestMethodCallbacks(Statement next, Method testMethod, Object testInstance, TestContextManager testContextManager) {
        return new RunAfterTestMethodCallbacks(next, testInstance, testMethod, testContextManager);
    }

    private Statement withTestInstancePreparation(Statement next, Object testInstance, TestContextManager testContextManager) {
        return new RunPrepareTestInstanceCallbacks(next, testInstance, testContextManager);
    }

    private Statement withPotentialRepeat(Statement next, Method testMethod, Object testInstance) {
        return new SpringRepeat(next, testMethod);
    }

    private Statement withPotentialTimeout(Statement next, Method testMethod, Object testInstance) {
        return new SpringFailOnTimeout(next, testMethod);
    }

    private Statement withProfileValueCheck(Statement next, Method testMethod, Object testInstance) {
        return new ProfileValueChecker(next, testInstance.getClass(), testMethod);
    }
}

