/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit.jupiter;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.annotation.Testable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.ParameterResolutionDelegate;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.event.ApplicationEvents;
import org.springframework.test.context.support.PropertyProvider;
import org.springframework.test.context.support.TestConstructorUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class SpringExtension
implements BeforeAllCallback,
AfterAllCallback,
TestInstancePostProcessor,
BeforeEachCallback,
AfterEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace TEST_CONTEXT_MANAGER_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{SpringExtension.class});
    private static final ExtensionContext.Namespace AUTOWIRED_VALIDATION_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{SpringExtension.class.getName() + "#autowired.validation"});
    private static final String NO_AUTOWIRED_VIOLATIONS_DETECTED = "NO AUTOWIRED VIOLATIONS DETECTED";
    private static final List<Class<? extends Annotation>> JUPITER_ANNOTATION_TYPES = Arrays.asList(BeforeAll.class, AfterAll.class, BeforeEach.class, AfterEach.class, Testable.class);
    private static final ReflectionUtils.MethodFilter autowiredTestOrLifecycleMethodFilter = ReflectionUtils.USER_DECLARED_METHODS.and(method -> !Modifier.isPrivate(method.getModifiers())).and(SpringExtension::isAutowiredTestOrLifecycleMethod);

    public void beforeAll(ExtensionContext context) throws Exception {
        SpringExtension.getTestContextManager(context).beforeTestClass();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        try {
            SpringExtension.getTestContextManager(context).afterTestClass();
        }
        finally {
            SpringExtension.getStore(context).remove((Object)context.getRequiredTestClass());
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        this.validateAutowiredConfig(context);
        SpringExtension.getTestContextManager(context).prepareTestInstance(testInstance);
    }

    private void validateAutowiredConfig(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(AUTOWIRED_VALIDATION_NAMESPACE);
        String errorMessage = (String)store.getOrComputeIfAbsent((Object)context.getRequiredTestClass(), testClass -> {
            Object[] methodsWithErrors = ReflectionUtils.getUniqueDeclaredMethods((Class)testClass, (ReflectionUtils.MethodFilter)autowiredTestOrLifecycleMethodFilter);
            return methodsWithErrors.length == 0 ? NO_AUTOWIRED_VIOLATIONS_DETECTED : String.format("Test methods and test lifecycle methods must not be annotated with @Autowired. You should instead annotate individual method parameters with @Autowired, @Qualifier, or @Value. Offending methods in test class %s: %s", testClass.getName(), Arrays.toString(methodsWithErrors));
        }, String.class);
        if (errorMessage != NO_AUTOWIRED_VIOLATIONS_DETECTED) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Object testInstance = context.getRequiredTestInstance();
        Method testMethod = context.getRequiredTestMethod();
        SpringExtension.getTestContextManager(context).beforeTestMethod(testInstance, testMethod);
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        Object testInstance = context.getRequiredTestInstance();
        Method testMethod = context.getRequiredTestMethod();
        SpringExtension.getTestContextManager(context).beforeTestExecution(testInstance, testMethod);
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        Object testInstance = context.getRequiredTestInstance();
        Method testMethod = context.getRequiredTestMethod();
        Throwable testException = context.getExecutionException().orElse(null);
        SpringExtension.getTestContextManager(context).afterTestExecution(testInstance, testMethod, testException);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Object testInstance = context.getRequiredTestInstance();
        Method testMethod = context.getRequiredTestMethod();
        Throwable testException = context.getExecutionException().orElse(null);
        SpringExtension.getTestContextManager(context).afterTestMethod(testInstance, testMethod, testException);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        PropertyProvider junitPropertyProvider;
        Class testClass;
        Parameter parameter = parameterContext.getParameter();
        Executable executable = parameter.getDeclaringExecutable();
        return TestConstructorUtils.isAutowirableConstructor(executable, testClass = extensionContext.getRequiredTestClass(), junitPropertyProvider = propertyName -> extensionContext.getConfigurationParameter(propertyName).orElse(null)) || ApplicationContext.class.isAssignableFrom(parameter.getType()) || this.supportsApplicationEvents(parameterContext) || ParameterResolutionDelegate.isAutowirable((Parameter)parameter, (int)parameterContext.getIndex());
    }

    private boolean supportsApplicationEvents(ParameterContext parameterContext) {
        if (ApplicationEvents.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            Assert.isTrue((boolean)(parameterContext.getDeclaringExecutable() instanceof Method), (String)"ApplicationEvents can only be injected into test and lifecycle methods");
            return true;
        }
        return false;
    }

    @Nullable
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        int index = parameterContext.getIndex();
        Class testClass = extensionContext.getRequiredTestClass();
        ApplicationContext applicationContext = SpringExtension.getApplicationContext(extensionContext);
        return ParameterResolutionDelegate.resolveDependency((Parameter)parameter, (int)index, (Class)testClass, (AutowireCapableBeanFactory)applicationContext.getAutowireCapableBeanFactory());
    }

    public static ApplicationContext getApplicationContext(ExtensionContext context) {
        return SpringExtension.getTestContextManager(context).getTestContext().getApplicationContext();
    }

    static TestContextManager getTestContextManager(ExtensionContext context) {
        Assert.notNull((Object)context, (String)"ExtensionContext must not be null");
        Class testClass = context.getRequiredTestClass();
        ExtensionContext.Store store = SpringExtension.getStore(context);
        return (TestContextManager)store.getOrComputeIfAbsent((Object)testClass, TestContextManager::new, TestContextManager.class);
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(TEST_CONTEXT_MANAGER_NAMESPACE);
    }

    private static boolean isAutowiredTestOrLifecycleMethod(Method method) {
        MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)method, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.DIRECT, (RepeatableContainers)RepeatableContainers.none());
        if (!mergedAnnotations.isPresent(Autowired.class)) {
            return false;
        }
        for (Class<? extends Annotation> annotationType : JUPITER_ANNOTATION_TYPES) {
            if (!mergedAnnotations.isPresent(annotationType)) continue;
            return true;
        }
        return false;
    }
}

