/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.annotation.Repeat;
import org.springframework.test.annotation.Timed;

public abstract class TestAnnotationUtils {
    public static long getTimeout(Method method) {
        Timed timed = (Timed)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Timed.class);
        return timed == null ? 0L : Math.max(0L, timed.millis());
    }

    public static int getRepeatCount(Method method) {
        Repeat repeat = (Repeat)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Repeat.class);
        if (repeat == null) {
            return 1;
        }
        return Math.max(1, repeat.value());
    }
}

