/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.servicedir;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.CompilationSet;
import com.google.gxp.compiler.CompilationUnit;
import com.google.gxp.compiler.base.Callable;
import com.google.gxp.compiler.base.Implementable;
import com.google.gxp.compiler.base.InstanceCallable;
import com.google.gxp.compiler.base.Root;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.servicedir.ServiceDirectory;

public class OnDemandServiceDirectory
implements ServiceDirectory {
    private final CompilationSet compilationSet;

    public OnDemandServiceDirectory(CompilationSet compilationSet) {
        this.compilationSet = Preconditions.checkNotNull(compilationSet);
    }

    private Root getRoot(TemplateName templateName) {
        if (templateName.getPackageName() == null) {
            throw new IllegalArgumentException("templateName must be fully qualified");
        }
        CompilationUnit compilationUnit = this.compilationSet.getCompilationUnit((TemplateName.FullyQualified)templateName);
        return compilationUnit == null ? null : (Root)compilationUnit.getReparentedTree().getRoot();
    }

    @Override
    public Callable getCallable(TemplateName templateName) {
        Root root = this.getRoot(templateName);
        return root == null ? null : root.getCallable();
    }

    @Override
    public InstanceCallable getInstanceCallable(TemplateName templateName) {
        Root root = this.getRoot(templateName);
        return root == null ? null : root.getInstanceCallable();
    }

    @Override
    public Implementable getImplementable(TemplateName templateName) {
        Root root = this.getRoot(templateName);
        return root == null ? null : root.getImplementable();
    }
}

