/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.fs;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.io.Bytes;
import com.google.gxp.com.google.common.io.Characters;
import com.google.gxp.compiler.fs.FileStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;

public final class FileRef
implements FileObject {
    private final FileStore store;
    private final String name;
    private static final String EXTENSION_CHARS = "[^\\./]*";
    private static final Pattern SUFFIX_CHARS_PATTERN = Pattern.compile("^[^\\/]*");
    private static final Pattern EXTENSION_PATTERN = Pattern.compile("\\.([^\\./]*)$");
    private static final Pattern NORMAL_PATTERN = Pattern.compile("/([^/]+(/[^/]+)*)?");
    private static final Pattern MULTIPLE_SLASH_PATTERN = Pattern.compile("//+");

    public FileRef(FileStore store, String name) {
        this.store = Preconditions.checkNotNull(store);
        this.name = FileRef.normalize(Preconditions.checkNotNull(name));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI toUri() {
        return this.store.toUri(this);
    }

    @Override
    public long getLastModified() {
        return this.store.getLastModified(this);
    }

    public long getChecksum() {
        try {
            Adler32 checksum = new Adler32();
            InputStream is = this.openInputStream();
            checksum.update(Bytes.toByteArray(is));
            is.close();
            return checksum.getValue();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public boolean delete() {
        return this.store.delete(this);
    }

    public Writer openWriter(Charset encoding) throws IOException {
        return new OutputStreamWriter(this.openOutputStream(), encoding.newEncoder());
    }

    @Override
    public Writer openWriter() throws IOException {
        return this.openWriter(this.store.getDefaultCharset());
    }

    public Reader openReader(Charset encoding) throws IOException {
        return new InputStreamReader(this.openInputStream(), encoding.newDecoder());
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return this.openReader(this.store.getDefaultCharset());
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.store.openInputStream(this);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return this.store.openOutputStream(this);
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return Characters.toString(this.openReader(ignoreEncodingErrors));
    }

    public FileRef removeExtension() {
        Matcher m = EXTENSION_PATTERN.matcher(this.name);
        return m.find() ? new FileRef(this.store, this.name.substring(0, m.start())) : this;
    }

    public JavaFileObject.Kind getKind() {
        Matcher m = EXTENSION_PATTERN.matcher(this.name);
        if (m.find()) {
            String extension = this.name.substring(m.start());
            for (JavaFileObject.Kind kind : JavaFileObject.Kind.values()) {
                if (!extension.equals(kind.extension)) continue;
                return kind;
            }
        }
        return JavaFileObject.Kind.OTHER;
    }

    public FileRef addSuffix(String suffix) {
        if (!SUFFIX_CHARS_PATTERN.matcher(suffix).matches()) {
            throw new IllegalArgumentException("Illegal characters in suffix, \"" + suffix + "\".");
        }
        return new FileRef(this.store, this.name + suffix);
    }

    public String toFilename() {
        return this.store.toFilename(this);
    }

    public String toRelativeFilename() {
        return this.store.toRelativeFilename(this);
    }

    public FileRef join(String suffix) {
        return new FileRef(this.store, this.name + "/" + suffix);
    }

    public boolean isAncestorOf(FileRef that) {
        return this.store.equals(that.store) && ("/".equals(this.name) || that.name.startsWith(this.name + "/"));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(\"" + this.store + ":" + this.name + "\")";
    }

    public int hashCode() {
        return Objects.hashCode(this.store, this.name);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof FileRef && this.equals((FileRef)that);
    }

    public boolean equals(FileRef that) {
        return this.store.equals(that.store) && this.name.equals(that.name);
    }

    private static String normalize(String name) {
        if (NORMAL_PATTERN.matcher(name).matches()) {
            return name;
        }
        String newName = MULTIPLE_SLASH_PATTERN.matcher("/" + name).replaceAll("/");
        if (newName.length() > 1 && newName.endsWith("/")) {
            return newName.substring(0, newName.length() - 1);
        }
        return newName;
    }
}

