/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.cpp;

import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.AbbrExpression;
import com.google.gxp.compiler.base.BooleanConstant;
import com.google.gxp.compiler.base.BoundCall;
import com.google.gxp.compiler.base.Call;
import com.google.gxp.compiler.base.CallVisitor;
import com.google.gxp.compiler.base.Concatenation;
import com.google.gxp.compiler.base.Conditional;
import com.google.gxp.compiler.base.ConvertibleToContent;
import com.google.gxp.compiler.base.DefaultingExpressionVisitor;
import com.google.gxp.compiler.base.EscapeExpression;
import com.google.gxp.compiler.base.ExampleExpression;
import com.google.gxp.compiler.base.ExceptionExpression;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.ExtractedMessage;
import com.google.gxp.compiler.base.Interface;
import com.google.gxp.compiler.base.IsXmlExpression;
import com.google.gxp.compiler.base.LoopExpression;
import com.google.gxp.compiler.base.NativeExpression;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.base.Template;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.base.UnboundCall;
import com.google.gxp.compiler.base.UnexpectedNodeException;
import com.google.gxp.compiler.base.ValidatedCall;
import com.google.gxp.compiler.cpp.BaseCppCodeGenerator;
import com.google.gxp.compiler.msgextract.MessageExtractedTree;
import java.util.Iterator;

public class CppCodeGenerator
extends BaseCppCodeGenerator<MessageExtractedTree> {
    public CppCodeGenerator(MessageExtractedTree tree) {
        super(tree);
    }

    @Override
    protected InterfaceWorker createInterfaceWorker(Appendable out, AlertSink alertSink, Interface iface) {
        return new InterfaceWorker(out, alertSink, iface);
    }

    @Override
    protected TemplateWorker createTemplateWorker(Appendable out, AlertSink alertSink, Template template) {
        return new TemplateWorker(out, alertSink, template);
    }

    private static class TemplateWorker
    extends BaseCppCodeGenerator.TemplateWorker {
        private static final int MAX_CPP_STRING_LENGTH = 65534;
        private final StatementVisitor statementVisitor = this.getStatementVisitor();
        private final ExpressionVisitor<String> toExpressionVisitor = this.getToExpressionVisitor();
        private final ExpressionVisitor<String> toEscapableExpressionVisitor = this.getToEscapableExpressionVisitor();

        public TemplateWorker(Appendable out, AlertSink alertSink, Template template) {
            super(out, alertSink, template);
        }

        @Override
        protected void appendClass() {
            this.appendInclude(this.template.getSourcePosition(), this.template.getName());
            this.appendLine();
            this.appendWriteMethod();
            this.appendLine();
            this.appendGetGxpClosureMethod();
        }

        protected void appendInclude(SourcePosition pos, TemplateName templateName) {
            String filename = templateName.toString().replace('.', '/');
            this.formatLine(pos, "#include \"%s.h\"", filename);
        }

        protected void appendWriteMethod() {
            this.appendLine(this.getWriteMethodSignature(true, true) + " {");
            this.template.getContent().acceptVisitor(this.statementVisitor);
            this.appendLine("}");
        }

        protected void appendGetGxpClosureMethod() {
            this.appendLine(this.getGetGxpClosureMethodSignature(true, true) + " {");
            this.appendLine("return NULL;");
            this.appendLine("}");
        }

        protected void writeExpression(SourcePosition pos, String expr) {
            this.appendLine(pos, "gxp_out->Append(" + expr + ");");
        }

        protected void writeString(SourcePosition pos, String s) {
            int length = s.length();
            if (length != 0) {
                int curPos = 0;
                while (length - curPos > 65534) {
                    this.writeExpression(pos, OutputLanguage.CPP.toStringLiteral(s.substring(curPos, curPos + 65534)));
                    curPos += 65534;
                }
                this.writeExpression(pos, OutputLanguage.CPP.toStringLiteral(s.substring(curPos, length)));
            }
        }

        protected StatementVisitor getStatementVisitor() {
            return new StatementVisitor();
        }

        protected ToExpressionVisitor getToExpressionVisitor() {
            return new ToExpressionVisitor();
        }

        protected ToEscapableExpressionVisitor getToEscapableExpressionVisitor() {
            return new ToEscapableExpressionVisitor();
        }

        protected String getCppExpression(Expression value) {
            return value.acceptVisitor(this.toExpressionVisitor);
        }

        protected String getEscapableExpression(Expression value) {
            return value.acceptVisitor(this.toEscapableExpressionVisitor);
        }

        protected class ToExpressionVisitor
        extends DefaultingExpressionVisitor<String> {
            protected ToExpressionVisitor() {
            }

            @Override
            public String defaultVisitExpression(Expression value) {
                throw new UnexpectedNodeException(value);
            }

            @Override
            public String visitBooleanConstant(BooleanConstant value) {
                return "";
            }

            @Override
            public String visitEscapeExpression(EscapeExpression value) {
                return value.getSubexpression().acceptVisitor(this);
            }

            @Override
            public String visitIsXmlExpression(IsXmlExpression ixe) {
                return "gxp_context.IsUsingXmlSyntax()";
            }

            @Override
            public String visitNativeExpression(NativeExpression value) {
                return "(" + OutputLanguage.CPP.validateExpression(TemplateWorker.this.alertSink, value) + ")";
            }
        }

        protected class ToEscapableExpressionVisitor
        extends DefaultingExpressionVisitor<String> {
            protected ToEscapableExpressionVisitor() {
            }

            @Override
            public String defaultVisitExpression(Expression value) {
                throw new UnexpectedNodeException(value);
            }

            @Override
            public String visitNativeExpression(NativeExpression value) {
                return "(" + OutputLanguage.CPP.validateExpression(TemplateWorker.this.alertSink, value) + ")";
            }

            @Override
            public String visitEscapeExpression(EscapeExpression value) {
                return "";
            }

            @Override
            public String visitExtractedMessage(ExtractedMessage msg) {
                return "";
            }
        }

        protected class StatementVisitor
        extends DefaultingExpressionVisitor<Void>
        implements CallVisitor<Void> {
            protected StatementVisitor() {
            }

            @Override
            public Void defaultVisitExpression(Expression node) {
                throw new UnexpectedNodeException(node);
            }

            @Override
            public Void visitAbbrExpression(AbbrExpression abbr) {
                return null;
            }

            @Override
            public Void visitCall(Call value) {
                return value.acceptCallVisitor(this);
            }

            @Override
            public Void visitConcatenation(Concatenation value) {
                for (Expression subValue : value.getValues()) {
                    subValue.acceptVisitor(this);
                }
                return null;
            }

            @Override
            public Void visitConditional(Conditional value) {
                Iterator<Conditional.Clause> clauses = value.getClauses().iterator();
                if (clauses.hasNext()) {
                    this.appendIf("if (", clauses.next());
                    while (clauses.hasNext()) {
                        this.appendIf("} else if (", clauses.next());
                    }
                    Expression elseExpression = value.getElseExpression();
                    if (!elseExpression.alwaysEmpty()) {
                        TemplateWorker.this.appendLine("} else {");
                        elseExpression.acceptVisitor(this);
                    }
                } else {
                    throw new AssertionError((Object)"No clauses in Conditional!");
                }
                TemplateWorker.this.appendLine("}");
                return null;
            }

            private void appendIf(String prefix, Conditional.Clause clause) {
                Expression predicate = clause.getPredicate();
                TemplateWorker.this.appendLine(predicate.getSourcePosition(), prefix + TemplateWorker.this.getCppExpression(predicate) + ") {");
                clause.getExpression().acceptVisitor(this);
            }

            @Override
            public Void visitConvertibleToContent(ConvertibleToContent value) {
                value.getSubexpression().acceptVisitor(this);
                return null;
            }

            @Override
            public Void visitEscapeExpression(EscapeExpression value) {
                return null;
            }

            @Override
            public Void visitExceptionExpression(ExceptionExpression value) {
                return null;
            }

            @Override
            public Void visitExampleExpression(ExampleExpression value) {
                return value.getSubexpression().acceptVisitor(this);
            }

            @Override
            public Void visitExtractedMessage(ExtractedMessage msg) {
                return null;
            }

            @Override
            public Void visitLoopExpression(LoopExpression loop) {
                return null;
            }

            @Override
            public Void visitStringConstant(StringConstant value) {
                if (value.getSchema() == null) {
                    throw new AssertionError();
                }
                TemplateWorker.this.writeString(value.getSourcePosition(), value.evaluate());
                return null;
            }

            @Override
            public Void visitBoundCall(BoundCall call) {
                throw new UnexpectedNodeException(call);
            }

            @Override
            public Void visitUnboundCall(UnboundCall call) {
                throw new UnexpectedNodeException(call);
            }

            @Override
            public Void visitValidatedCall(ValidatedCall call) {
                return null;
            }
        }
    }

    private static class InterfaceWorker
    extends BaseCppCodeGenerator.InterfaceWorker {
        public InterfaceWorker(Appendable out, AlertSink alertSink, Interface iface) {
            super(out, alertSink, iface);
        }

        @Override
        protected void appendClass() {
        }
    }
}

