/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.collapse;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.AttrBundleParam;
import com.google.gxp.compiler.base.Call;
import com.google.gxp.compiler.base.CollapseExpression;
import com.google.gxp.compiler.base.Concatenation;
import com.google.gxp.compiler.base.DefaultingExpressionVisitor;
import com.google.gxp.compiler.base.ExhaustiveExpressionVisitor;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExtractedMessage;
import com.google.gxp.compiler.base.NoMessage;
import com.google.gxp.compiler.base.OutputElement;
import com.google.gxp.compiler.base.Root;
import com.google.gxp.compiler.base.SpaceOperator;
import com.google.gxp.compiler.base.SpaceOperatorSet;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.base.UnexpectedNodeException;
import com.google.gxp.compiler.base.UnextractedMessage;
import com.google.gxp.compiler.base.Util;
import com.google.gxp.compiler.bind.BoundTree;
import com.google.gxp.compiler.collapse.SpaceCollapsedTree;
import com.google.gxp.compiler.reparent.Attribute;
import com.google.gxp.compiler.schema.ElementValidator;
import com.google.gxp.compiler.schema.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpaceCollapser
implements Function<BoundTree, SpaceCollapsedTree> {
    private static final Pattern LEADING_SPACES = Pattern.compile("^(\\s+)(.*?)$", 32);
    private static final Pattern TRAILING_SPACES = Pattern.compile("^(.*?)(\\s+)$", 32);
    private static final Pattern ONLY_SPACES = Pattern.compile("^\\s*$", 32);
    private static final Pattern SPACES = Pattern.compile("\\s+", 32);
    private static final SpaceOperatorSet DEFAULT_SPACE_OPERATORS = new SpaceOperatorSet(SpaceOperator.COLLAPSE, SpaceOperator.REMOVE);
    private static final SpaceOperatorSet PRESERVING_SPACE_OPERATORS = new SpaceOperatorSet(SpaceOperator.PRESERVE, SpaceOperator.PRESERVE);
    private static final SpaceOperatorSet ATTR_SPACE_OPERATORS = new SpaceOperatorSet(SpaceOperator.NORMALIZE, SpaceOperator.REMOVE);
    private static final SpaceOperatorSet MESSAGE_SPACE_OPERATORS = new SpaceOperatorSet(SpaceOperator.NORMALIZE, SpaceOperator.REMOVE);

    @Override
    public SpaceCollapsedTree apply(BoundTree tree) {
        Root root = tree.getRoot().acceptVisitor(new SearchingVisitor());
        return new SpaceCollapsedTree(tree.getSourcePosition(), tree.getAlerts(), root);
    }

    private static class CollapsingVisitor
    extends DefaultingExpressionVisitor<Expression> {
        private final SpaceOperatorSet spaceOperators;

        CollapsingVisitor(SpaceOperatorSet spaceOperators) {
            this.spaceOperators = Preconditions.checkNotNull(spaceOperators);
        }

        @Override
        public Expression defaultVisitExpression(Expression value) {
            return value;
        }

        @Override
        public Expression visitCollapseExpression(CollapseExpression value) {
            throw new UnexpectedNodeException(value);
        }

        @Override
        public Expression visitStringConstant(StringConstant value) {
            return Concatenation.create(value.getSourcePosition(), null, this.processConcatenation(value.getSchema(), Collections.singletonList(value)));
        }

        @Override
        public Expression visitConcatenation(Concatenation value) {
            return value.withValues(this.processConcatenation(value.getSchema(), value.getValues()));
        }

        private List<Expression> processConcatenation(Schema schema, List<? extends Expression> values) {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> textSegments = Lists.newArrayList();
            ArrayList<SourcePosition> textPositions = Lists.newArrayList();
            ArrayList<Expression> nonTextValues = Lists.newArrayList();
            SourcePosition sbPos = null;
            for (Expression expression : values) {
                if (expression instanceof StringConstant) {
                    StringConstant stringConstant = (StringConstant)expression;
                    sb.append(stringConstant.evaluate());
                    if (sbPos != null) continue;
                    sbPos = stringConstant.getSourcePosition();
                    continue;
                }
                textSegments.add(sb.toString());
                sb.setLength(0);
                textPositions.add(sbPos);
                sbPos = null;
                nonTextValues.add(expression);
            }
            textSegments.add(sb.toString());
            textPositions.add(sbPos);
            ArrayList<Expression> result = Lists.newArrayList();
            SpaceOperator interiorSpaceOperator = this.spaceOperators.getInteriorSpaceOperator();
            SpaceOperator spaceOperator = this.spaceOperators.getExteriorSpaceOperator();
            int textSegmentCount = textSegments.size();
            if (textSegmentCount > 0) {
                String text;
                int i;
                Matcher m = LEADING_SPACES.matcher((CharSequence)textSegments.get(0));
                String leadingSpaces = "";
                if (m.matches()) {
                    leadingSpaces = spaceOperator.apply(m.group(1));
                    textSegments.set(0, m.group(2));
                }
                m = TRAILING_SPACES.matcher((CharSequence)textSegments.get(textSegmentCount - 1));
                String trailingSpaces = "";
                if (m.matches()) {
                    trailingSpaces = spaceOperator.apply(m.group(2));
                    textSegments.set(textSegmentCount - 1, m.group(1));
                }
                for (i = 0; i < textSegmentCount; ++i) {
                    text = (String)textSegments.get(i);
                    if (text.length() <= 0) continue;
                    sb.setLength(0);
                    m = SPACES.matcher(text);
                    int start = 0;
                    while (m.find(start)) {
                        sb.append(text, start, m.start());
                        start = m.end();
                        sb.append(interiorSpaceOperator.apply(m.group()));
                    }
                    sb.append(text, start, text.length());
                    textSegments.set(i, sb.toString());
                }
                textSegments.set(0, leadingSpaces + (String)textSegments.get(0));
                textSegments.set(textSegmentCount - 1, (String)textSegments.get(textSegmentCount - 1) + trailingSpaces);
                for (i = 0; i < textSegmentCount; ++i) {
                    text = (String)textSegments.get(i);
                    if (text.length() > 0) {
                        result.add(new StringConstant((SourcePosition)textPositions.get(i), schema, text));
                    }
                    if (i >= textSegmentCount - 1) continue;
                    result.add((Expression)nonTextValues.get(i));
                }
            }
            return result;
        }
    }

    private static class SearchingVisitor
    extends ExhaustiveExpressionVisitor {
        private final SpaceOperatorSet spaceOperators;
        private boolean useSpecialAttrCollapsing = true;

        SearchingVisitor() {
            this(DEFAULT_SPACE_OPERATORS);
        }

        private SearchingVisitor(SpaceOperatorSet spaceOperators) {
            this.spaceOperators = Preconditions.checkNotNull(spaceOperators);
        }

        public SearchingVisitor with(SpaceOperatorSet newSpaceOperators) {
            return this.spaceOperators.equals(newSpaceOperators) ? this : new SearchingVisitor(newSpaceOperators);
        }

        @Override
        public Expression visitCollapseExpression(CollapseExpression value) {
            SpaceOperatorSet newSpaceOperators = value.getSpaceOperators().inheritFrom(this.spaceOperators);
            SearchingVisitor subVisitor = this.with(newSpaceOperators);
            Expression subExpression = value.getSubexpression().acceptVisitor(subVisitor);
            CollapsingVisitor collapsingVisitor = new CollapsingVisitor(newSpaceOperators);
            return subExpression.acceptVisitor(collapsingVisitor);
        }

        @Override
        public Expression visitExtractedMessage(ExtractedMessage msg) {
            throw new UnexpectedNodeException(msg);
        }

        @Override
        public Expression visitUnextractedMessage(UnextractedMessage msg) {
            SearchingVisitor contentVisitor = this.with(MESSAGE_SPACE_OPERATORS);
            return msg.withContent(msg.getContent().acceptVisitor(contentVisitor));
        }

        @Override
        public Expression visitNoMessage(NoMessage nomsg) {
            SearchingVisitor contentVisitor = this.with(MESSAGE_SPACE_OPERATORS);
            return nomsg.withSubexpression(nomsg.getSubexpression().acceptVisitor(contentVisitor));
        }

        @Override
        public Attribute visitAttribute(Attribute attr) {
            Expression newValue = this.useSpecialAttrCollapsing ? this.with(ATTR_SPACE_OPERATORS).apply(attr.getValue()) : this.apply(attr.getValue());
            Expression newCondition = attr.getCondition();
            if (newCondition != null) {
                newCondition = this.apply(newCondition);
            }
            return attr.withValue(newValue).withCondition(newCondition);
        }

        @Override
        public Expression visitOutputElement(OutputElement element) {
            boolean oldUseSpecialAttrCollapsing = this.useSpecialAttrCollapsing;
            this.useSpecialAttrCollapsing = true;
            ElementValidator validator = element.getValidator();
            SearchingVisitor contentVisitor = validator.isFlagSet(ElementValidator.Flag.PRESERVESPACES) ? this.with(PRESERVING_SPACE_OPERATORS) : this;
            OutputElement result = element.withAttributesAndContent(Util.map(element.getAttributes(), this.getAttributeFunction()), element.getContent().acceptVisitor(contentVisitor));
            this.useSpecialAttrCollapsing = oldUseSpecialAttrCollapsing;
            return result;
        }

        @Override
        public Expression visitAttrBundleParam(AttrBundleParam bundle) {
            boolean oldUseSpecialAttrCollapsing = this.useSpecialAttrCollapsing;
            this.useSpecialAttrCollapsing = true;
            Expression result = super.visitAttrBundleParam(bundle);
            this.useSpecialAttrCollapsing = oldUseSpecialAttrCollapsing;
            return result;
        }

        @Override
        public Expression visitCall(Call call) {
            boolean oldUseSpecialAttrCollapsing = this.useSpecialAttrCollapsing;
            this.useSpecialAttrCollapsing = false;
            Expression result = super.visitCall(call);
            this.useSpecialAttrCollapsing = oldUseSpecialAttrCollapsing;
            return result;
        }
    }
}

