/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Function;
import java.util.regex.Pattern;

public enum SpaceOperator implements Function<String, String>
{
    PRESERVE{

        @Override
        public String impl(String s) {
            return s;
        }
    }
    ,
    REMOVE{

        @Override
        public String impl(String s) {
            return "";
        }
    }
    ,
    NORMALIZE{

        @Override
        public String impl(String s) {
            return s.length() > 0 ? " " : "";
        }
    }
    ,
    COLLAPSE{

        @Override
        public String impl(String s) {
            if (s.contains("\n") || s.contains("\f")) {
                return "\n";
            }
            return NORMALIZE.impl(s);
        }
    };

    private static final Pattern WHITESPACE_ONLY;

    protected abstract String impl(String var1);

    @Override
    public String apply(String s) {
        if (WHITESPACE_ONLY.matcher(s).matches()) {
            return this.impl(s);
        }
        throw new IllegalArgumentException("Cannot apply SpaceOperator to non-spaces!");
    }

    static {
        WHITESPACE_ONLY = Pattern.compile("^\\s*$");
    }
}

