/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler;

import com.google.gxp.com.google.common.base.Charsets;
import com.google.gxp.com.google.common.base.Join;
import com.google.gxp.com.google.common.base.Predicate;
import com.google.gxp.com.google.common.base.Predicates;
import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Sets;
import com.google.gxp.compiler.CompilationManager;
import com.google.gxp.compiler.CompilationSet;
import com.google.gxp.compiler.CompilationUnit;
import com.google.gxp.compiler.Configuration;
import com.google.gxp.compiler.InvalidConfigException;
import com.google.gxp.compiler.Phase;
import com.google.gxp.compiler.SimpleCompilationManager;
import com.google.gxp.compiler.alerts.AlertPolicy;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.UniquifyingAlertSink;
import com.google.gxp.compiler.alerts.common.IOError;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.codegen.CodeGeneratorFactory;
import com.google.gxp.compiler.depend.DependencyGraph;
import com.google.gxp.compiler.dot.DotWriter;
import com.google.gxp.compiler.dot.GraphSink;
import com.google.gxp.compiler.dot.ReflectiveGraphRenderer;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.parser.Parser;
import com.google.gxp.compiler.parser.SaxXmlParser;
import com.google.gxp.compiler.parser.SourceEntityResolver;
import com.google.gxp.compiler.schema.BuiltinSchemaFactory;
import com.google.gxp.compiler.schema.DelegatingSchemaFactory;
import com.google.gxp.compiler.schema.FileBackedSchemaFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Compiler {
    private final ImmutableSet<FileRef> sourceFiles;
    private final ImmutableSet<FileRef> schemaFiles;
    private final ImmutableSet<OutputLanguage> outputLanguages;
    private final CodeGeneratorFactory codeGeneratorFactory;
    private final ImmutableSet<FileRef> allowedOutputs;
    private final FileRef dependencyFile;
    private final FileRef propertiesFile;
    private final AlertPolicy alertPolicy;
    private final ImmutableSet<Phase> dotPhases;
    private final SourceEntityResolver entityResolver;

    public Compiler(Configuration config) throws InvalidConfigException {
        Compiler.validateAllowedOutputs(config.getAllowedOutputFileRefs(), config.getOutputLanguages(), config.getSourceFiles());
        this.sourceFiles = ImmutableSet.copyOf(config.getSourceFiles());
        this.schemaFiles = ImmutableSet.copyOf(config.getSchemaFiles());
        this.outputLanguages = ImmutableSet.copyOf(config.getOutputLanguages());
        this.codeGeneratorFactory = config.getCodeGeneratorFactory();
        this.allowedOutputs = ImmutableSet.copyOf(config.getAllowedOutputFileRefs());
        this.dependencyFile = config.getDependencyFile();
        this.propertiesFile = config.getPropertiesFile();
        this.alertPolicy = config.getAlertPolicy();
        this.dotPhases = ImmutableSet.copyOf(config.getDotPhases());
        this.entityResolver = config.getEntityResolver();
    }

    public void call(AlertSink alertSink) {
        alertSink = new UniquifyingAlertSink(alertSink);
        DelegatingSchemaFactory schemaFactory = new DelegatingSchemaFactory(new FileBackedSchemaFactory(alertSink, this.schemaFiles), new BuiltinSchemaFactory(alertSink));
        Parser parser = new Parser(schemaFactory, SaxXmlParser.INSTANCE, this.entityResolver);
        CompilationManager manager = this.readCompilationManager();
        CompilationSet.Builder compilationSetBuilder = new CompilationSet.Builder(parser, this.codeGeneratorFactory, manager).setPropertiesFile(this.propertiesFile);
        CompilationSet compilationSet = compilationSetBuilder.build(this.sourceFiles);
        Predicate<FileRef> shouldCompileFilePredicate = this.allowedOutputs.isEmpty() ? Predicates.alwaysTrue() : Predicates.in(this.allowedOutputs);
        compilationSet.compile(alertSink, this.alertPolicy, this.outputLanguages, shouldCompileFilePredicate);
        this.writeDotFiles(compilationSet, alertSink);
        this.writeCompilationManager(new DependencyGraph(compilationSet));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDotFiles(CompilationSet compilationSet, AlertSink alertSink) {
        List<CompilationUnit> compilationUnits = compilationSet.getCompilationUnits();
        int i = 0;
        for (Phase phase : Phase.values()) {
            ++i;
            if (!this.dotPhases.contains((Object)phase)) continue;
            String suffix = String.format(".%02d.%s.dot", i, phase.name().toLowerCase().replace("_", "-"));
            for (CompilationUnit compilationUnit : compilationUnits) {
                FileRef fileRef = compilationUnit.getSourceFileRef().removeExtension().addSuffix(suffix);
                try {
                    Writer writer = fileRef.openWriter(Charsets.US_ASCII);
                    try {
                        DotWriter out = new DotWriter(writer);
                        ReflectiveGraphRenderer renderer = new ReflectiveGraphRenderer(phase.name().toLowerCase());
                        renderer.renderGraph((GraphSink)out, phase.getForest(compilationUnit).getChildren());
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException iox) {
                    alertSink.add(new IOError(fileRef, iox));
                }
            }
        }
    }

    private CompilationManager readCompilationManager() {
        CompilationManager manager = SimpleCompilationManager.INSTANCE;
        if (this.dependencyFile != null) {
            try {
                ObjectInputStream ois = new ObjectInputStream(this.dependencyFile.openInputStream());
                Object read = ois.readObject();
                if (read instanceof CompilationManager) {
                    manager = (CompilationManager)read;
                }
                ois.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return manager;
    }

    private void writeCompilationManager(CompilationManager manager) {
        if (this.dependencyFile != null) {
            try {
                ObjectOutputStream oos = new ObjectOutputStream(this.dependencyFile.openOutputStream());
                oos.writeObject(manager);
                oos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void validateAllowedOutputs(Set<FileRef> allowedOutputs, Iterable<OutputLanguage> outputLanguages, Iterable<FileRef> sourceFileRefs) throws InvalidConfigException {
        if (!allowedOutputs.isEmpty()) {
            Set<FileRef> possibleOutputs = Compiler.computePossibleOutputs(outputLanguages, sourceFileRefs);
            ArrayList<String> impossibleOutputs = Lists.newArrayList();
            for (FileRef allowedOutput : allowedOutputs) {
                if (possibleOutputs.contains(allowedOutput)) continue;
                impossibleOutputs.add(allowedOutput.toFilename());
            }
            if (!impossibleOutputs.isEmpty()) {
                Collections.sort(impossibleOutputs);
                throw new InvalidConfigException("The following are listed as allowed output files but are not possible given the specified inputs: " + Join.join(", ", impossibleOutputs));
            }
        }
    }

    private static Set<FileRef> computePossibleOutputs(Iterable<OutputLanguage> outputLanguages, Iterable<FileRef> sourceFileRefs) {
        HashSet<FileRef> result = Sets.newHashSet();
        for (FileRef sourceFileRef : sourceFileRefs) {
            for (OutputLanguage language : outputLanguages) {
                FileRef outputFileRef = sourceFileRef.removeExtension().addSuffix(language.getSuffix());
                result.add(outputFileRef);
            }
        }
        return result;
    }
}

