/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.util.Collection;
import java.util.List;
import net.sf.oval.Validator;

public final class StringUtils {
    public static boolean isBlank(String str) {
        if (StringUtils.isEmpty(str)) {
            return true;
        }
        int i = 0;
        int l = str.length();
        while (i < l) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String join(Collection<?> values, char delimiter) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        StringBuilder out = new StringBuilder(3 * values.size());
        boolean isFirst = true;
        for (Object value : values) {
            if (isFirst) {
                isFirst = false;
            } else {
                out.append(delimiter);
            }
            out.append(value);
        }
        return out.toString();
    }

    public static String join(Object[] values, char delimiter) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder out = new StringBuilder(3 * values.length);
        int i = 0;
        int l = values.length;
        while (i < l) {
            if (i > 0) {
                out.append(delimiter);
            }
            out.append(values[i]);
            ++i;
        }
        return out.toString();
    }

    public static String replaceAll(String searchIn, String searchFor, String replaceWith) {
        StringBuilder out = new StringBuilder();
        int startAt = 0;
        int foundAt = 0;
        int searchForLength = searchFor.length();
        while ((foundAt = searchIn.indexOf(searchFor, startAt)) >= 0) {
            out.append(searchIn.substring(startAt, foundAt)).append(replaceWith);
            startAt = foundAt + searchForLength;
        }
        return out.append(searchIn.substring(startAt)).toString();
    }

    public static List<String> split(String str, char separator, int maxParts) {
        List<String> result = Validator.getCollectionFactory().createList();
        int startAt = 0;
        while (true) {
            int foundAt;
            if ((foundAt = str.indexOf(separator, startAt)) == -1 || result.size() == maxParts - 1) break;
            result.add(str.substring(startAt, foundAt));
            startAt = foundAt + 1;
        }
        result.add(str.substring(startAt));
        return result;
    }

    public static String substringBeforeLast(String str, char delimiter) {
        int pos = str.lastIndexOf(delimiter);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    private StringUtils() {
    }
}

