/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.ValidationCycle;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.ValidateWithMethod;
import net.sf.oval.exception.InvalidConfigurationException;
import net.sf.oval.exception.ReflectionException;
import net.sf.oval.internal.util.ReflectionUtils;

public class ValidateWithMethodCheck
extends AbstractAnnotationCheck<ValidateWithMethod> {
    private static final long serialVersionUID = 1L;
    private final ConcurrentMap<Class<?>, Method> validationMethodsByClass = Validator.getCollectionFactory().createConcurrentMap();
    private boolean ignoreIfNull;
    private String methodName;
    private Class<?> parameterType;

    @Override
    public void configure(ValidateWithMethod constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMethodName(constraintAnnotation.methodName());
        this.setParameterType(constraintAnnotation.parameterType());
        this.setIgnoreIfNull(constraintAnnotation.ignoreIfNull());
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(4);
        messageVariables.put("ignoreIfNull", Boolean.toString(this.ignoreIfNull));
        messageVariables.put("methodName", this.methodName);
        messageVariables.put("parameterType", this.parameterType.getName());
        return messageVariables;
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?> getParameterType() {
        return this.parameterType;
    }

    public boolean isIgnoreIfNull() {
        return this.ignoreIfNull;
    }

    private Method getValidationMethod(Class<?> clazz) {
        return ReflectionUtils.getMethodRecursive(clazz, this.methodName, this.parameterType);
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, ValidationCycle cycle) throws ReflectionException {
        if (valueToValidate == null && this.ignoreIfNull) {
            return true;
        }
        Class<?> clazz = validatedObject.getClass();
        Method method = this.validationMethodsByClass.computeIfAbsent(clazz, this::getValidationMethod);
        if (method == null) {
            throw new InvalidConfigurationException("Method " + clazz.getName() + "." + this.methodName + "(" + this.parameterType + ") not found. Is [" + this.parameterType + "] the correct value for [@ValidateWithMethod.parameterType]?");
        }
        return (Boolean)ReflectionUtils.invokeMethod(method, validatedObject, valueToValidate);
    }

    public void setIgnoreIfNull(boolean ignoreIfNull) {
        this.ignoreIfNull = ignoreIfNull;
        this.requireMessageVariablesRecreation();
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
        this.validationMethodsByClass.clear();
        this.requireMessageVariablesRecreation();
    }

    public void setParameterType(Class<?> parameterType) {
        this.parameterType = parameterType;
        this.validationMethodsByClass.clear();
        this.requireMessageVariablesRecreation();
    }
}

