/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.ValidationCycle;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.RelativeDateRange;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.StringUtils;

public class RelativeDateRangeCheck
extends AbstractAnnotationCheck<RelativeDateRange> {
    private static final Log LOG = Log.getLog(RelativeDateRangeCheck.class);
    private static final long serialVersionUID = 1L;
    private String format;
    private String plus;
    private String minus;
    private long tolerance = 0L;

    @Override
    public void configure(RelativeDateRange constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setPlus(constraintAnnotation.plus());
        this.setMinus(constraintAnnotation.minus());
        this.setFormat(constraintAnnotation.format());
        this.setTolerance(constraintAnnotation.tolerance());
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(3);
        messageVariables.put("minus", this.minus.isEmpty() ? "-" : String.valueOf(Duration.parse(this.minus).getSeconds()));
        messageVariables.put("plus", this.plus.isEmpty() ? "-" : String.valueOf(Duration.parse(this.plus).getSeconds()));
        return messageVariables;
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public String getFormat() {
        return this.format;
    }

    public String getMinus() {
        return this.minus;
    }

    public String getPlus() {
        return this.plus;
    }

    public long getTolerance() {
        return this.tolerance;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, ValidationCycle cycle) {
        Instant instant;
        if (valueToValidate == null) {
            return true;
        }
        if (StringUtils.isEmpty(this.plus) && StringUtils.isEmpty(this.minus)) {
            LOG.debug("No relative date range was configured.");
            return true;
        }
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime target = null;
        if (valueToValidate instanceof Date) {
            instant = ((Date)valueToValidate).toInstant();
            target = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        } else if (valueToValidate instanceof Calendar) {
            instant = ((Calendar)valueToValidate).toInstant();
            target = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        } else if (valueToValidate instanceof ZonedDateTime) {
            target = (ZonedDateTime)valueToValidate;
        } else if (valueToValidate instanceof LocalDateTime) {
            target = ZonedDateTime.of((LocalDateTime)valueToValidate, ZoneId.systemDefault());
        } else {
            String stringValue = valueToValidate.toString();
            try {
                if (this.format != null) {
                    try {
                        TemporalAccessor parse = DateTimeFormatter.ofPattern(this.format).parseBest(stringValue, ZonedDateTime::from, LocalDateTime::from);
                        target = parse instanceof ZonedDateTime ? (ZonedDateTime)parse : ZonedDateTime.of((LocalDateTime)parse, ZoneId.systemDefault());
                    }
                    catch (DateTimeParseException ex) {
                        LOG.debug("valueToValidate not parsable with specified format {1}", (Object)this.format, ex);
                    }
                }
                if (target == null) {
                    target = ZonedDateTime.parse(stringValue);
                }
            }
            catch (DateTimeParseException ex) {
                LOG.debug("valueToValidate is unparsable.", ex);
                return false;
            }
        }
        boolean inRange = true;
        if (!StringUtils.isEmpty(this.minus)) {
            ZonedDateTime min = now.minus(Duration.parse(this.minus));
            boolean bl = inRange = min.isBefore(target) || Math.abs(min.toEpochSecond() - target.toEpochSecond()) <= this.tolerance;
        }
        if (inRange && !StringUtils.isEmpty(this.plus)) {
            ZonedDateTime max = now.plus(Duration.parse(this.plus));
            inRange = max.isAfter(target) || Math.abs(max.toEpochSecond() - target.toEpochSecond()) <= this.tolerance;
        }
        return inRange;
    }

    public void setFormat(String format) {
        this.format = format;
        this.requireMessageVariablesRecreation();
    }

    public void setMinus(String minus) {
        this.minus = minus;
        this.requireMessageVariablesRecreation();
    }

    public void setPlus(String plus) {
        this.plus = plus;
        this.requireMessageVariablesRecreation();
    }

    public void setTolerance(long tolerance) {
        this.tolerance = tolerance;
    }
}

