/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.configuration.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.validation.Constraint;
import javax.validation.Valid;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.FutureOrPresent;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.PastOrPresent;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import net.sf.oval.Check;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.collection.CollectionFactory;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.annotation.Validatable;
import net.sf.oval.configuration.pojo.elements.ClassConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstraintSetConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstructorConfiguration;
import net.sf.oval.configuration.pojo.elements.FieldConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodReturnValueConfiguration;
import net.sf.oval.configuration.pojo.elements.ParameterConfiguration;
import net.sf.oval.constraint.AssertFalseCheck;
import net.sf.oval.constraint.AssertNullCheck;
import net.sf.oval.constraint.AssertTrueCheck;
import net.sf.oval.constraint.AssertValidCheck;
import net.sf.oval.constraint.DateRangeCheck;
import net.sf.oval.constraint.DigitsCheck;
import net.sf.oval.constraint.FutureCheck;
import net.sf.oval.constraint.MatchPatternCheck;
import net.sf.oval.constraint.MaxCheck;
import net.sf.oval.constraint.MinCheck;
import net.sf.oval.constraint.NotBlankCheck;
import net.sf.oval.constraint.NotEmptyCheck;
import net.sf.oval.constraint.NotNegativeCheck;
import net.sf.oval.constraint.NotNullCheck;
import net.sf.oval.constraint.PastCheck;
import net.sf.oval.constraint.SizeCheck;
import net.sf.oval.guard.Guarded;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ArrayUtils;
import net.sf.oval.internal.util.ReflectionUtils;

public class BeanValidationAnnotationsConfigurer
implements Configurer {
    private static final Log LOG = Log.getLog(BeanValidationAnnotationsConfigurer.class);
    private static final ConstraintMapper CONSTRAINT_MAPPER;

    static {
        JSR303Mapper constraintMapper = null;
        try {
            constraintMapper = new JSR380Mapper();
        }
        catch (LinkageError linkageError) {
            constraintMapper = new JSR303Mapper();
        }
        CONSTRAINT_MAPPER = constraintMapper;
    }

    private List<ParameterConfiguration> _createParameterConfigs(Class<?>[] paramTypes, Annotation[][] paramAnnos, AnnotatedType[] annotatedParamTypes) {
        CollectionFactory cf = Validator.getCollectionFactory();
        List<ParameterConfiguration> paramCfgs = cf.createList(paramAnnos.length);
        List<Check> paramChecks = cf.createList(2);
        int i = 0;
        while (i < paramAnnos.length) {
            Annotation[] annotationArray = paramAnnos[i];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation anno = annotationArray[n2];
                this.initializeChecks(anno, paramChecks, ConstraintTarget.CONTAINER);
                ++n2;
            }
            this.initializeGenericTypeChecks(paramTypes[i], annotatedParamTypes[i], paramChecks);
            ParameterConfiguration paramCfg = new ParameterConfiguration();
            paramCfgs.add(paramCfg);
            paramCfg.type = paramTypes[i];
            if (!paramChecks.isEmpty()) {
                paramCfg.checks = paramChecks;
                paramChecks = cf.createList(2);
            }
            ++i;
        }
        return paramCfgs;
    }

    protected void configureCtorParamChecks(ClassConfiguration classCfg) {
        Constructor<?>[] constructorArray = classCfg.type.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> ctor = constructorArray[n2];
            List<ParameterConfiguration> paramCfg = this._createParameterConfigs(ctor.getParameterTypes(), ctor.getParameterAnnotations(), ctor.getAnnotatedParameterTypes());
            if (!paramCfg.isEmpty()) {
                if (classCfg.constructorConfigurations == null) {
                    classCfg.constructorConfigurations = Validator.getCollectionFactory().createSet(2);
                }
                ConstructorConfiguration cc = new ConstructorConfiguration();
                cc.parameterConfigurations = paramCfg;
                cc.postCheckInvariants = false;
                classCfg.constructorConfigurations.add(cc);
            }
            ++n2;
        }
    }

    protected void configureFieldChecks(ClassConfiguration classCfg) {
        CollectionFactory cf = Validator.getCollectionFactory();
        List<Check> checks = cf.createList(2);
        Field[] fieldArray = classCfg.type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Annotation[] annotationArray = field.getAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation anno = annotationArray[n4];
                this.initializeChecks(anno, checks, ConstraintTarget.CONTAINER);
                ++n4;
            }
            this.initializeGenericTypeChecks(field.getType(), field.getAnnotatedType(), checks);
            if (!checks.isEmpty()) {
                if (classCfg.fieldConfigurations == null) {
                    classCfg.fieldConfigurations = cf.createSet(2);
                }
                FieldConfiguration fc = new FieldConfiguration();
                fc.name = field.getName();
                fc.checks = checks;
                classCfg.fieldConfigurations.add(fc);
                checks = cf.createList(2);
            }
            ++n2;
        }
    }

    protected void configureMethodChecks(ClassConfiguration classCfg) {
        CollectionFactory cf = Validator.getCollectionFactory();
        List<Check> returnValueChecks = cf.createList(2);
        Method[] methodArray = classCfg.type.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Annotation[] annotationArray = ReflectionUtils.getAnnotations(method, Boolean.TRUE.equals(classCfg.inspectInterfaces), classCfg.includedInterfaces, classCfg.excludedInterfaces);
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation anno = annotationArray[n4];
                this.initializeChecks(anno, returnValueChecks, ConstraintTarget.CONTAINER);
                ++n4;
            }
            this.initializeGenericTypeChecks(method.getReturnType(), method.getAnnotatedReturnType(), returnValueChecks);
            List<ParameterConfiguration> paramCfg = this._createParameterConfigs(method.getParameterTypes(), ReflectionUtils.getParameterAnnotations(method, Boolean.TRUE.equals(classCfg.inspectInterfaces), classCfg.includedInterfaces, classCfg.excludedInterfaces), method.getAnnotatedParameterTypes());
            if (!paramCfg.isEmpty() || !returnValueChecks.isEmpty()) {
                if (classCfg.methodConfigurations == null) {
                    classCfg.methodConfigurations = cf.createSet(2);
                }
                MethodConfiguration mc = new MethodConfiguration();
                mc.name = method.getName();
                mc.parameterConfigurations = paramCfg;
                mc.isInvariant = ReflectionUtils.isGetter(method);
                if (!returnValueChecks.isEmpty()) {
                    mc.returnValueConfiguration = new MethodReturnValueConfiguration();
                    mc.returnValueConfiguration.checks = returnValueChecks;
                    returnValueChecks = cf.createList(2);
                }
                classCfg.methodConfigurations.add(mc);
            }
            ++n2;
        }
    }

    @Override
    public ClassConfiguration getClassConfiguration(Class<?> clazz) {
        ClassConfiguration classCfg = new ClassConfiguration();
        classCfg.type = clazz;
        Guarded guarded = clazz.getAnnotation(Guarded.class);
        Validatable validatable = clazz.getAnnotation(Validatable.class);
        if (guarded == null) {
            classCfg.applyFieldConstraintsToConstructors = false;
            classCfg.applyFieldConstraintsToSetters = false;
            classCfg.assertParametersNotNull = false;
            classCfg.checkInvariants = false;
            classCfg.inspectInterfaces = validatable == null || validatable.inspectInterfaces();
        } else {
            classCfg.applyFieldConstraintsToConstructors = guarded.applyFieldConstraintsToConstructors();
            classCfg.applyFieldConstraintsToSetters = guarded.applyFieldConstraintsToSetters();
            classCfg.assertParametersNotNull = guarded.assertParametersNotNull();
            classCfg.checkInvariants = guarded.checkInvariants();
            classCfg.inspectInterfaces = validatable == null ? guarded.inspectInterfaces() : validatable.inspectInterfaces();
        }
        if (validatable != null) {
            classCfg.excludedInterfaces = ArrayUtils.asSet(validatable.excludedInterfaces());
            classCfg.includedInterfaces = ArrayUtils.asSet(validatable.includedInterfaces());
        }
        this.configureFieldChecks(classCfg);
        this.configureCtorParamChecks(classCfg);
        this.configureMethodChecks(classCfg);
        return classCfg;
    }

    @Override
    public ConstraintSetConfiguration getConstraintSetConfiguration(String constraintSetId) {
        return null;
    }

    protected void initializeChecks(Annotation anno, Collection<Check> checks, ConstraintTarget ... targetOverrides) {
        Annotation[] listAnnos;
        assert (anno != null);
        assert (checks != null);
        Class<? extends Annotation> annoClass = anno.annotationType();
        if (annoClass.getAnnotation(Constraint.class) != null || anno instanceof Valid) {
            Check[] mappedChecks = CONSTRAINT_MAPPER.map(anno);
            if (mappedChecks != null) {
                Check[] checkArray = mappedChecks;
                int n = mappedChecks.length;
                int n2 = 0;
                while (n2 < n) {
                    Class[] groups;
                    Method getGroups;
                    String message;
                    Method getMessage;
                    Check check = checkArray[n2];
                    if (targetOverrides.length > 0 && !(anno instanceof Valid)) {
                        check.setAppliesTo(targetOverrides);
                    }
                    if ((getMessage = ReflectionUtils.getMethod(annoClass, "message", new Class[0])) != null && (message = (String)ReflectionUtils.invokeMethod(getMessage, anno, new Object[0])) != null && !message.startsWith("{javax.validation.constraints.")) {
                        check.setMessage(message);
                    }
                    if ((getGroups = ReflectionUtils.getMethod(annoClass, "groups", new Class[0])) != null && (groups = (Class[])ReflectionUtils.invokeMethod(getGroups, anno, new Object[0])) != null && groups.length > 0) {
                        String[] profiles = new String[groups.length];
                        int i = 0;
                        int l = groups.length;
                        while (i < l) {
                            profiles[i] = groups[i].getName();
                            ++i;
                        }
                        check.setProfiles(profiles);
                    }
                    checks.add(check);
                    ++n2;
                }
                return;
            }
            LOG.warn("Ignoring unsupported bean validation constraint annotation {1}", anno);
            return;
        }
        if (annoClass.getPackage().getName().equals("javax.validation.constraints") && "List".equals(annoClass.getSimpleName()) && (listAnnos = (Annotation[])ReflectionUtils.invokeMethod(ReflectionUtils.getMethod(annoClass, "value", new Class[0]), anno, new Object[0])) != null) {
            Annotation[] annotationArray = listAnnos;
            int n = listAnnos.length;
            int n3 = 0;
            while (n3 < n) {
                Annotation listAnno = annotationArray[n3];
                this.initializeChecks(listAnno, checks, targetOverrides);
                ++n3;
            }
        }
    }

    protected void initializeGenericTypeChecks(Class<?> type, AnnotatedType annotatedType, List<Check> checks) {
        block3: {
            Annotation annotation;
            AnnotatedParameterizedType fieldAPType;
            block4: {
                if (!(annotatedType instanceof AnnotatedParameterizedType)) break block3;
                fieldAPType = (AnnotatedParameterizedType)annotatedType;
                if (!Collection.class.isAssignableFrom(type)) break block4;
                AnnotatedType genericArgType = fieldAPType.getAnnotatedActualTypeArguments()[0];
                Annotation[] annotationArray = genericArgType.getAnnotations();
                int n = annotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation annotation2 = annotationArray[n2];
                    this.initializeChecks(annotation2, checks, ConstraintTarget.VALUES);
                    ++n2;
                }
                break block3;
            }
            if (!Map.class.isAssignableFrom(type)) break block3;
            AnnotatedType genericArgType = fieldAPType.getAnnotatedActualTypeArguments()[0];
            Annotation[] annotationArray = genericArgType.getAnnotations();
            int n = annotationArray.length;
            int n3 = 0;
            while (n3 < n) {
                annotation = annotationArray[n3];
                this.initializeChecks(annotation, checks, ConstraintTarget.KEYS);
                ++n3;
            }
            genericArgType = fieldAPType.getAnnotatedActualTypeArguments()[1];
            annotationArray = genericArgType.getAnnotations();
            n = annotationArray.length;
            n3 = 0;
            while (n3 < n) {
                annotation = annotationArray[n3];
                this.initializeChecks(annotation, checks, ConstraintTarget.VALUES);
                ++n3;
            }
        }
    }

    private static interface ConstraintMapper {
        public Check[] map(Annotation var1);
    }

    private static class JSR303Mapper
    implements ConstraintMapper {
        private JSR303Mapper() {
        }

        @Override
        public Check[] map(Annotation anno) {
            if (anno instanceof NotNull) {
                return new Check[]{new NotNullCheck()};
            }
            if (anno instanceof Null) {
                return new Check[]{new AssertNullCheck()};
            }
            if (anno instanceof Valid) {
                return new Check[]{new AssertValidCheck()};
            }
            if (anno instanceof AssertTrue) {
                return new Check[]{new AssertTrueCheck()};
            }
            if (anno instanceof AssertFalse) {
                return new Check[]{new AssertFalseCheck()};
            }
            if (anno instanceof DecimalMax) {
                MaxCheck check = new MaxCheck();
                check.setMax(Double.parseDouble(((DecimalMax)anno).value()));
                Method getInclusive = ReflectionUtils.getMethod(anno.annotationType(), "inclusive", new Class[0]);
                if (getInclusive != null) {
                    check.setInclusive((Boolean)ReflectionUtils.invokeMethod(getInclusive, anno, new Object[0]));
                }
                return new Check[]{check};
            }
            if (anno instanceof DecimalMin) {
                MinCheck check = new MinCheck();
                check.setMin(Double.parseDouble(((DecimalMin)anno).value()));
                Method getInclusive = ReflectionUtils.getMethod(anno.annotationType(), "inclusive", new Class[0]);
                if (getInclusive != null) {
                    check.setInclusive((Boolean)ReflectionUtils.invokeMethod(getInclusive, anno, new Object[0]));
                }
                return new Check[]{check};
            }
            if (anno instanceof Max) {
                MaxCheck check = new MaxCheck();
                check.setMax(((Max)anno).value());
                return new Check[]{check};
            }
            if (anno instanceof Min) {
                MinCheck check = new MinCheck();
                check.setMin(((Min)anno).value());
                return new Check[]{check};
            }
            if (anno instanceof Future) {
                return new Check[]{new FutureCheck()};
            }
            if (anno instanceof Past) {
                return new Check[]{new PastCheck()};
            }
            if (anno instanceof Pattern) {
                MatchPatternCheck check = new MatchPatternCheck();
                int iflag = 0;
                Pattern.Flag[] flagArray = ((Pattern)anno).flags();
                int n = flagArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Pattern.Flag flag = flagArray[n2];
                    iflag |= flag.getValue();
                    ++n2;
                }
                check.setPattern(((Pattern)anno).regexp(), iflag);
                return new Check[]{check};
            }
            if (anno instanceof Digits) {
                DigitsCheck check = new DigitsCheck();
                check.setMaxFraction(((Digits)anno).fraction());
                check.setMaxInteger(((Digits)anno).integer());
                return new Check[]{check};
            }
            if (anno instanceof Size) {
                SizeCheck check = new SizeCheck();
                check.setMax(((Size)anno).max());
                check.setMin(((Size)anno).min());
                return new Check[]{check};
            }
            return null;
        }

        /* synthetic */ JSR303Mapper(JSR303Mapper jSR303Mapper, JSR303Mapper jSR303Mapper2) {
            this();
        }
    }

    private static class JSR380Mapper
    extends JSR303Mapper {
        private JSR380Mapper() {
            super(null, null);
        }

        @Override
        public Check[] map(Annotation anno) {
            Check[] jsr303checks = super.map(anno);
            if (jsr303checks != null) {
                return jsr303checks;
            }
            if (anno instanceof FutureOrPresent) {
                DateRangeCheck check = new DateRangeCheck();
                check.setMin("now");
                return new Check[]{check};
            }
            if (anno instanceof Negative) {
                MaxCheck check = new MaxCheck();
                check.setInclusive(false);
                check.setMax(0.0);
                return new Check[]{check};
            }
            if (anno instanceof NegativeOrZero) {
                MaxCheck check = new MaxCheck();
                check.setInclusive(true);
                check.setMax(0.0);
                return new Check[]{check};
            }
            if (anno instanceof NotBlank) {
                return new Check[]{new NotNullCheck(), new NotBlankCheck()};
            }
            if (anno instanceof NotEmpty) {
                return new Check[]{new NotNullCheck(), new NotEmptyCheck()};
            }
            if (anno instanceof PastOrPresent) {
                DateRangeCheck check = new DateRangeCheck();
                check.setMax("now");
                return new Check[]{check};
            }
            if (anno instanceof Positive) {
                MinCheck check = new MinCheck();
                check.setInclusive(false);
                check.setMin(0.0);
                return new Check[]{check};
            }
            if (anno instanceof PositiveOrZero) {
                return new Check[]{new NotNegativeCheck()};
            }
            return null;
        }
    }
}

