/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.rest.handler;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.opensymphony.xwork2.ActionInvocation;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.rest.handler.AbstractContentTypeHandler;

public class JacksonXmlHandler
extends AbstractContentTypeHandler {
    private static final Logger LOG = LogManager.getLogger(JacksonXmlHandler.class);
    private static final String DEFAULT_CONTENT_TYPE = "application/xml";
    private XmlMapper mapper = new XmlMapper();

    @Override
    public void toObject(ActionInvocation invocation, Reader in, Object target) throws IOException {
        LOG.debug("Converting input into an object of: {}", (Object)target.getClass().getName());
        ObjectReader or = this.mapper.readerForUpdating(target);
        or.readValue(in);
    }

    @Override
    public String fromObject(ActionInvocation invocation, Object obj, String resultCode, Writer stream) throws IOException {
        LOG.debug("Converting an object of {} into string", (Object)obj.getClass().getName());
        this.mapper.writeValue(stream, obj);
        return null;
    }

    @Override
    public String getContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    @Override
    public String getExtension() {
        return "xml";
    }
}

