/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.jasper.runtime;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.SimpleInstanceManager;

public class InstanceHelper {
    private static final Map<ClassLoader, InstanceManager> INSTANCE_MANAGERS = Collections.synchronizedMap(new WeakHashMap());

    private InstanceHelper() {
    }

    public static InstanceManager getServletInstanceManager(ServletConfig servletConfig) {
        if (servletConfig == null) {
            return null;
        }
        ServletContext servletContext = servletConfig.getServletContext();
        if (servletContext == null) {
            return null;
        }
        ClassLoader classLoader = servletContext.getClassLoader();
        Object potentialInstanceManager = servletContext.getAttribute(InstanceManager.class.getName());
        if (potentialInstanceManager == null) {
            SimpleInstanceManager instanceManager = new SimpleInstanceManager();
            InstanceHelper.setClassLoaderInstanceManager(classLoader, (InstanceManager)instanceManager);
            servletContext.setAttribute(InstanceManager.class.getName(), (Object)instanceManager);
            return instanceManager;
        }
        InstanceManager instanceManager = InstanceHelper.getClassLoaderInstanceManager(classLoader);
        if (instanceManager == null || !instanceManager.equals(potentialInstanceManager)) {
            if (potentialInstanceManager instanceof InstanceManager) {
                instanceManager = (InstanceManager)potentialInstanceManager;
                InstanceHelper.setClassLoaderInstanceManager(classLoader, instanceManager);
                return instanceManager;
            }
            return null;
        }
        return instanceManager;
    }

    public static InstanceManager getClassLoaderInstanceManager(ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        InstanceManager instanceManager = INSTANCE_MANAGERS.get(classLoader);
        if (instanceManager == null) {
            instanceManager = new SimpleInstanceManager();
            InstanceHelper.setClassLoaderInstanceManager(classLoader, instanceManager);
        }
        return instanceManager;
    }

    protected static void setClassLoaderInstanceManager(ClassLoader classLoader, InstanceManager instanceManager) {
        if (classLoader != null) {
            INSTANCE_MANAGERS.put(classLoader, instanceManager);
        }
    }

    public static void postConstruct(InstanceManager instanceManager, Object instance) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NamingException {
        if (instanceManager == null) {
            throw new IllegalArgumentException("postConstruct - instanceManager is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("postConstruct - instanceClass is null");
        }
        instanceManager.newInstance(instance);
    }

    public static void preDestroy(InstanceManager instanceManager, Object instance) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (instanceManager == null) {
            throw new IllegalArgumentException("preDestroy - instanceManager is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("preDestroy - instance is null");
        }
        instanceManager.destroyInstance(instance);
    }
}

