/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.servlet.Servlet;
import org.apache.struts2.JSPLoader;

public class ServletCache {
    protected final ConcurrentMap<String, Future<Servlet>> cache = new ConcurrentHashMap<String, Future<Servlet>>();
    private final JSPLoader jspLoader = new JSPLoader();

    public void clear() {
        this.cache.clear();
    }

    /*
     * Loose catch block
     */
    public Servlet get(final String location) throws InterruptedException {
        while (true) {
            Callable<Servlet> loadJSPCallable;
            FutureTask<Servlet> futureTask;
            FutureTask<Servlet> future;
            if ((future = (FutureTask<Servlet>)this.cache.get(location)) == null && (future = (Future)this.cache.putIfAbsent(location, futureTask = new FutureTask<Servlet>(loadJSPCallable = new Callable<Servlet>(){

                @Override
                public Servlet call() throws Exception {
                    return ServletCache.this.jspLoader.load(location);
                }
            }))) == null) {
                future = futureTask;
                futureTask.run();
            }
            try {
                return (Servlet)future.get();
            }
            catch (CancellationException e) {
                this.cache.remove(location, future);
                continue;
            }
            break;
        }
        catch (ExecutionException e) {
            throw ServletCache.launderThrowable(e.getCause());
        }
    }

    public static RuntimeException launderThrowable(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IllegalStateException(t);
    }
}

