/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import java.util.Map;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.AbstractExpressionLanguage;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ObjectCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionLanguageJavaScriptImpl
extends AbstractExpressionLanguage {
    private static final Log LOG = Log.getLog(ExpressionLanguageJavaScriptImpl.class);
    private final Scriptable parentScope;
    private final ObjectCache<String, Script> scriptCache = new ObjectCache();

    public ExpressionLanguageJavaScriptImpl() {
        Context ctx = ContextFactory.getGlobal().enterContext();
        try {
            this.parentScope = ctx.initStandardObjects();
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public Object evaluate(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        LOG.debug("Evaluating JavaScript expression: {1}", expression);
        try {
            Context ctx = ContextFactory.getGlobal().enterContext();
            Script script = this.scriptCache.get(expression);
            if (script == null) {
                ctx.setOptimizationLevel(9);
                script = ctx.compileString(expression, "<cmd>", 1, null);
                this.scriptCache.put(expression, script);
            }
            Scriptable scope = ctx.newObject(this.parentScope);
            scope.setPrototype(this.parentScope);
            scope.setParentScope(null);
            for (Map.Entry<String, ?> entry : values.entrySet()) {
                scope.put(entry.getKey(), scope, Context.javaToJS(entry.getValue(), (Scriptable)scope));
            }
            Object object = script.exec(ctx, scope);
            return object;
        }
        catch (EvaluatorException ex) {
            throw new ExpressionEvaluationException("Evaluating JavaScript expression failed: " + expression, ex);
        }
        finally {
            Context.exit();
        }
    }
}

