/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.freemarker.servlet;

import freemarker.cache.TemplateLoader;
import freemarker.ext.servlet.FreemarkerServlet;
import freemarker.template.Configuration;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.tiles.request.freemarker.servlet.SharedVariableFactory;
import org.apache.tiles.request.freemarker.servlet.WebappClassTemplateLoader;
import org.apache.tiles.request.reflect.ClassUtil;

public class SharedVariableLoaderFreemarkerServlet
extends FreemarkerServlet {
    private static final long serialVersionUID = 4301098067909854507L;
    public static final String CUSTOM_SHARED_VARIABLE_FACTORIES_INIT_PARAM = "org.apache.tiles.request.freemarker.CUSTOM_SHARED_VARIABLE_FACTORIES";
    private Map<String, SharedVariableFactory> name2variableFactory = new LinkedHashMap<String, SharedVariableFactory>();

    public void init(ServletConfig config) throws ServletException {
        String param = config.getInitParameter(CUSTOM_SHARED_VARIABLE_FACTORIES_INIT_PARAM);
        if (param != null) {
            String[] couples = param.split("\\s*;\\s*");
            for (int i = 0; i < couples.length; ++i) {
                String[] couple = couples[i].split("\\s*,\\s*");
                if (couple == null || couple.length != 2) {
                    throw new ServletException("Cannot parse custom shared variable partial init param: '" + couples[i] + "'");
                }
                this.name2variableFactory.put(couple[0], (SharedVariableFactory)ClassUtil.instantiate((String)couple[1]));
            }
        }
        super.init((ServletConfig)new ExcludingParameterServletConfig(config));
    }

    public void addSharedVariableFactory(String variableName, SharedVariableFactory factory) {
        this.name2variableFactory.put(variableName, factory);
    }

    protected Configuration createConfiguration() {
        Configuration configuration = super.createConfiguration();
        for (Map.Entry<String, SharedVariableFactory> entry : this.name2variableFactory.entrySet()) {
            configuration.setSharedVariable(entry.getKey(), entry.getValue().create());
        }
        return configuration;
    }

    protected TemplateLoader createTemplateLoader(String templatePath) {
        return new WebappClassTemplateLoader(this.getServletContext());
    }

    private static class SkippingEnumeration
    implements Enumeration<String> {
        private Enumeration<String> enumeration;
        private String next = null;

        public SkippingEnumeration(Enumeration<String> enumeration) {
            this.enumeration = enumeration;
            this.updateNextElement();
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        @Override
        public String nextElement() {
            String retValue = this.next;
            this.updateNextElement();
            return retValue;
        }

        private void updateNextElement() {
            String value = null;
            boolean done = false;
            while (this.enumeration.hasMoreElements() && !done) {
                value = this.enumeration.nextElement();
                if (value.equals(SharedVariableLoaderFreemarkerServlet.CUSTOM_SHARED_VARIABLE_FACTORIES_INIT_PARAM)) {
                    value = null;
                    continue;
                }
                done = true;
            }
            this.next = value;
        }
    }

    private class ExcludingParameterServletConfig
    implements ServletConfig {
        private ServletConfig config;

        public ExcludingParameterServletConfig(ServletConfig config) {
            this.config = config;
        }

        public String getServletName() {
            return this.config.getServletName();
        }

        public ServletContext getServletContext() {
            return this.config.getServletContext();
        }

        public String getInitParameter(String name) {
            if (SharedVariableLoaderFreemarkerServlet.CUSTOM_SHARED_VARIABLE_FACTORIES_INIT_PARAM.equals(name)) {
                return null;
            }
            return this.config.getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return new SkippingEnumeration(this.config.getInitParameterNames());
        }
    }
}

