/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.builder;

import java.util.Map;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.testing.mock.sling.builder.ImmutableValueMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImmutableValueMapTest {
    private static final Map<String, Object> SAMPLE_PROPS = Map.of("prop1", "value1", "prop2", 55);
    private ValueMap underTest;

    @Before
    public void setUp() {
        this.underTest = ImmutableValueMap.copyOf(SAMPLE_PROPS);
    }

    @Test
    public void testProperties() {
        Assert.assertEquals((Object)"value1", (Object)this.underTest.get("prop1", String.class));
        Assert.assertEquals((Object)55, (Object)this.underTest.get("prop2", Integer.class));
    }

    @Test
    public void testDefault() {
        Assert.assertEquals((Object)"def", (Object)this.underTest.get("prop3", (Object)"def"));
    }

    @Test
    public void testMapAccessMethods() {
        Assert.assertEquals((long)2L, (long)this.underTest.size());
        Assert.assertFalse((boolean)this.underTest.isEmpty());
        Assert.assertTrue((boolean)this.underTest.containsKey((Object)"prop1"));
        Assert.assertTrue((boolean)this.underTest.containsValue((Object)"value1"));
        Assert.assertEquals((Object)"value1", (Object)this.underTest.get((Object)"prop1"));
        Assert.assertTrue((boolean)this.underTest.keySet().contains("prop1"));
        Assert.assertTrue((boolean)this.underTest.values().contains("value1"));
        Assert.assertEquals((long)2L, (long)this.underTest.entrySet().size());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testMapClear() {
        this.underTest.clear();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testMapRemove() {
        this.underTest.remove((Object)"prop2");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testMapPut() {
        this.underTest.put((Object)"prop3", (Object)"value3");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testMapPutAll() {
        this.underTest.putAll(Map.of("prop4", 25, "prop5", 33));
    }

    @Test
    public void testOf() {
        ImmutableValueMap map = ImmutableValueMap.of();
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testOfx1() {
        ImmutableValueMap map = ImmutableValueMap.of((String)"p1", (Object)"v1");
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"v1", (Object)map.get((Object)"p1"));
    }

    @Test
    public void testOfx2() {
        ImmutableValueMap map = ImmutableValueMap.of((String)"p1", (Object)"v1", (String)"p2", (Object)"v2");
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"v1", (Object)map.get((Object)"p1"));
        Assert.assertEquals((Object)"v2", (Object)map.get((Object)"p2"));
    }

    @Test
    public void testOfx3() {
        ImmutableValueMap map = ImmutableValueMap.of((String)"p1", (Object)"v1", (String)"p2", (Object)"v2", (String)"p3", (Object)"v3");
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((Object)"v1", (Object)map.get((Object)"p1"));
        Assert.assertEquals((Object)"v2", (Object)map.get((Object)"p2"));
        Assert.assertEquals((Object)"v3", (Object)map.get((Object)"p3"));
    }

    @Test
    public void testOfx4() {
        ImmutableValueMap map = ImmutableValueMap.of((String)"p1", (Object)"v1", (String)"p2", (Object)"v2", (String)"p3", (Object)"v3", (String)"p4", (Object)"v4");
        Assert.assertEquals((long)4L, (long)map.size());
        Assert.assertEquals((Object)"v1", (Object)map.get((Object)"p1"));
        Assert.assertEquals((Object)"v2", (Object)map.get((Object)"p2"));
        Assert.assertEquals((Object)"v3", (Object)map.get((Object)"p3"));
        Assert.assertEquals((Object)"v4", (Object)map.get((Object)"p4"));
    }

    @Test
    public void testOfx5() {
        ImmutableValueMap map = ImmutableValueMap.of((String)"p1", (Object)"v1", (String)"p2", (Object)"v2", (String)"p3", (Object)"v3", (String)"p4", (Object)"v4", (String)"p5", (Object)"v5");
        Assert.assertEquals((long)5L, (long)map.size());
        Assert.assertEquals((Object)"v1", (Object)map.get((Object)"p1"));
        Assert.assertEquals((Object)"v2", (Object)map.get((Object)"p2"));
        Assert.assertEquals((Object)"v3", (Object)map.get((Object)"p3"));
        Assert.assertEquals((Object)"v4", (Object)map.get((Object)"p4"));
        Assert.assertEquals((Object)"v5", (Object)map.get((Object)"p5"));
    }

    @Test
    public void testBuilder() {
        ImmutableValueMap map = ImmutableValueMap.builder().put("p1", (Object)"v1").putAll(Map.of("p2", "v2", "p3", "v3")).put(Map.of("p4", "v4").entrySet().iterator().next()).put("p5", (Object)"v5").build();
        Assert.assertEquals((long)5L, (long)map.size());
        Assert.assertEquals((Object)"v1", (Object)map.get((Object)"p1"));
        Assert.assertEquals((Object)"v2", (Object)map.get((Object)"p2"));
        Assert.assertEquals((Object)"v3", (Object)map.get((Object)"p3"));
        Assert.assertEquals((Object)"v4", (Object)map.get((Object)"p4"));
        Assert.assertEquals((Object)"v5", (Object)map.get((Object)"p5"));
    }

    @Test
    public void testBuilderEmpty() {
        ImmutableValueMap map = ImmutableValueMap.builder().build();
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testCopyOfValueMap() {
        ValueMapDecorator valueMap = new ValueMapDecorator(SAMPLE_PROPS);
        ImmutableValueMap map = ImmutableValueMap.copyOf((Map)valueMap);
        Assert.assertEquals((long)map.size(), (long)SAMPLE_PROPS.size());
    }

    @Test
    public void testEquals() {
        ImmutableValueMap map1 = ImmutableValueMap.builder().put("prop1", (Object)"value1").put("prop2", (Object)55).build();
        ImmutableValueMap map2 = ImmutableValueMap.builder().put("prop1", (Object)"value1").put("prop2", (Object)55).build();
        ImmutableValueMap map3 = ImmutableValueMap.builder().put("prop1", (Object)"value2").put("prop2", (Object)55).build();
        Assert.assertEquals((Object)map1, (Object)map2);
        Assert.assertEquals((Object)map2, (Object)map1);
        Assert.assertNotEquals((Object)map1, (Object)map3);
        Assert.assertNotEquals((Object)map2, (Object)map3);
        Assert.assertNotEquals((Object)map1, (Object)new Object());
    }

    @Test(expected=Test.None.class)
    public void testHashCode() {
        this.underTest.hashCode();
    }

    @Test
    public void testToString() {
        Assert.assertNotNull((Object)this.underTest.toString());
    }
}

