/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.blob;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

public class BlobStoreInputStream
extends InputStream {
    private final BlobStore store;
    private final String id;
    private long pos;
    private byte[] oneByteBuff;

    public BlobStoreInputStream(BlobStore store, String id, long pos) {
        this.store = store;
        this.id = id;
        this.pos = pos;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int l;
        try {
            l = this.store.readBlob(this.id, this.pos, b, off, len);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (l < 0) {
            return l;
        }
        this.pos += (long)l;
        return l;
    }

    @Override
    public int read() throws IOException {
        int len;
        if (this.oneByteBuff == null) {
            this.oneByteBuff = new byte[1];
        }
        if ((len = this.read(this.oneByteBuff, 0, 1)) < 0) {
            return len;
        }
        return this.oneByteBuff[0] & 0xFF;
    }

    public static byte[] readFully(BlobStore store, String id) throws IOException {
        int len = (int)store.getBlobLength(id);
        byte[] buff = new byte[len];
        BlobStoreInputStream in = new BlobStoreInputStream(store, id, 0L);
        IOUtils.readFully(in, buff, 0, len);
        return buff;
    }
}

