/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.util;

import java.text.StringCharacterIterator;

public class LogSanitizer {
    public static final char REPLACEMENT_CHAR = '_';

    public String sanitize(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(input.length());
        StringCharacterIterator it = new StringCharacterIterator(input);
        char c = it.first();
        while (c != '\uffff') {
            result.append(LogSanitizer.accept(c) ? c : (char)'_');
            c = it.next();
        }
        return result.toString();
    }

    private static boolean accept(char c) {
        if (c > '\u007f') {
            return false;
        }
        if (c == '\n' || c == '\r') {
            return true;
        }
        return !Character.isISOControl(c);
    }
}

