/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.agent.impl.SimpleDistributionAgentAuthenticationInfo;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.util.impl.DistributionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TriggerAgentRequestHandler
implements DistributionRequestHandler {
    private final SimpleDistributionAgentAuthenticationInfo authenticationInfo;
    private final DefaultDistributionLog log;
    private final boolean active;
    private final DistributionAgent agent;
    private final String agentName;

    public TriggerAgentRequestHandler(@NotNull DistributionAgent agent, @NotNull String agentName, @NotNull SimpleDistributionAgentAuthenticationInfo authenticationInfo, @NotNull DefaultDistributionLog log, boolean active) {
        this.authenticationInfo = authenticationInfo;
        this.log = log;
        this.active = active;
        this.agent = agent;
        this.agentName = agentName;
    }

    @Override
    public String getName() {
        return this.agentName;
    }

    @Override
    public DistributionComponentKind getComponentKind() {
        return DistributionComponentKind.AGENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handle(@Nullable ResourceResolver resourceResolver, @NotNull DistributionRequest request) {
        if (!this.active) {
            this.log.warn("skipping agent handler as agent is disabled", new Object[0]);
            return;
        }
        if (resourceResolver != null) {
            try {
                this.agent.execute(resourceResolver, request);
                return;
            }
            catch (Throwable t) {
                this.log.error("Error executing handler {}", request, t);
                return;
            }
        }
        ResourceResolver agentResourceResolver = null;
        try {
            agentResourceResolver = DistributionUtils.getResourceResolver(null, this.authenticationInfo.getAgentService(), this.authenticationInfo.getSlingRepository(), this.authenticationInfo.getSubServiceName(), this.authenticationInfo.getResourceResolverFactory());
            this.agent.execute(agentResourceResolver, request);
        }
        catch (Throwable e) {
            try {
                this.log.error("Error executing handler {}", request, e);
            }
            catch (Throwable throwable) {
                DistributionUtils.ungetResourceResolver(agentResourceResolver);
                throw throwable;
            }
            DistributionUtils.ungetResourceResolver(agentResourceResolver);
            return;
        }
        DistributionUtils.ungetResourceResolver(agentResourceResolver);
        return;
    }

    public String toString() {
        return "TriggerAgentRequestHandler{agentName='" + this.agentName + '\'' + '}';
    }
}

