/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.cs.DefaultAffineCS;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCylindricalCS;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.apache.sis.referencing.cs.DefaultLinearCS;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.cs.DefaultPolarCS;
import org.apache.sis.referencing.cs.DefaultSphericalCS;
import org.apache.sis.referencing.cs.DefaultTimeCS;
import org.apache.sis.referencing.cs.DefaultUserDefinedCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.cs.Normalizer;
import org.apache.sis.referencing.cs.SubTypes;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.internal.shared.NilReferencingObject;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.referencing.internal.shared.WKTUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.util.FactoryException;

@XmlType(name="AbstractCoordinateSystemType")
@XmlRootElement(name="AbstractCoordinateSystem")
@XmlSeeAlso(value={DefaultAffineCS.class, DefaultCartesianCS.class, DefaultSphericalCS.class, DefaultEllipsoidalCS.class, DefaultCylindricalCS.class, DefaultPolarCS.class, DefaultLinearCS.class, DefaultVerticalCS.class, DefaultTimeCS.class, DefaultParametricCS.class, DefaultUserDefinedCS.class})
public class AbstractCS
extends AbstractIdentifiedObject
implements CoordinateSystem {
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.referencing");
    private static final long serialVersionUID = 3394376886951478970L;
    static final int VALID = 0;
    static final int INVALID_DIRECTION = 1;
    static final int INVALID_UNIT = 2;
    private CoordinateSystemAxis[] axes;
    private final EnumMap<AxesConvention, AbstractCS> forConvention;
    private static final CoordinateSystemAxis[] EMPTY = new CoordinateSystemAxis[0];

    private static EnumMap<AxesConvention, AbstractCS> forConvention(AbstractCS original) {
        EnumMap<AxesConvention, AbstractCS> m = new EnumMap<AxesConvention, AbstractCS>(AxesConvention.class);
        m.put(AxesConvention.ORIGINAL, original);
        return m;
    }

    public AbstractCS(Map<String, ?> properties, CoordinateSystemAxis ... axes) {
        super(properties);
        this.axes = (CoordinateSystemAxis[])axes.clone();
        this.validate(properties);
        this.forConvention = AbstractCS.forConvention(this);
    }

    void validate(Map<String, ?> properties) {
        for (int i = 0; i < this.axes.length; ++i) {
            CoordinateSystemAxis axis = this.axes[i];
            ArgumentChecks.ensureNonNullElement((String)"axes", (int)i, (Object)axis);
            ReferenceIdentifier name = axis.getName();
            ArgumentChecks.ensureNonNullElement((String)"axes[#].name", (int)i, (Object)name);
            AxisDirection direction = axis.getDirection();
            ArgumentChecks.ensureNonNullElement((String)"axes[#].direction", (int)i, (Object)direction);
            Unit unit = axis.getUnit();
            ArgumentChecks.ensureNonNullElement((String)"axes[#].unit", (int)i, (Object)unit);
            switch (this.validateAxis(direction, unit)) {
                case 1: {
                    throw new IllegalArgumentException(Resources.forProperties(properties).getString((short)20, this.getClass(), direction));
                }
                case 2: {
                    throw new IllegalArgumentException(Resources.forProperties(properties).getString((short)26, name, unit));
                }
            }
            AxisDirection dir = AxisDirections.absolute(direction);
            if (dir == AxisDirections.UNSPECIFIED || dir == AxisDirection.OTHER) continue;
            int j = i;
            while (--j >= 0) {
                AxisDirection other = this.axes[j].getDirection();
                AxisDirection abs = AxisDirections.absolute(other);
                if (dir != abs || abs == AxisDirection.FUTURE) continue;
                throw new IllegalArgumentException(Resources.forProperties(properties).getString((short)10, direction, other));
            }
        }
    }

    int validateAxis(AxisDirection direction, Unit<?> unit) {
        return 0;
    }

    AbstractCS(AbstractCS original, String name, CoordinateSystemAxis[] axes) {
        super(original.getPropertiesWithoutIdentifiers(name));
        this.axes = axes;
        this.validate(null);
        this.forConvention = this.hasSameAxes(original) ? original.forConvention : AbstractCS.forConvention(original);
    }

    protected AbstractCS(CoordinateSystem original) {
        super((IdentifiedObject)original);
        this.axes = original instanceof AbstractCS ? ((AbstractCS)original).axes : AbstractCS.getAxes(original);
        this.validate(null);
        this.forConvention = AbstractCS.forConvention(this);
    }

    private static CoordinateSystemAxis[] getAxes(CoordinateSystem cs) {
        CoordinateSystemAxis[] axes = new CoordinateSystemAxis[cs.getDimension()];
        for (int i = 0; i < axes.length; ++i) {
            axes[i] = cs.getAxis(i);
        }
        return axes;
    }

    public static AbstractCS castOrCopy(CoordinateSystem object) {
        return SubTypes.castOrCopy(object);
    }

    public Class<? extends CoordinateSystem> getInterface() {
        return CoordinateSystem.class;
    }

    final Map<String, ?> getPropertiesWithoutIdentifiers(String name) {
        return ReferencingUtilities.getPropertiesWithoutIdentifiers(this, name == null ? null : Map.of("name", name));
    }

    public final int getDimension() {
        return this.axes.length;
    }

    public final CoordinateSystemAxis getAxis(int dimension) throws IndexOutOfBoundsException {
        return this.axes[dimension];
    }

    public final boolean hasSameAxes(CoordinateSystem other) {
        if (other.getDimension() != this.axes.length) {
            return false;
        }
        CoordinateSystemAxis[] copy = AbstractCS.getAxes(other);
        int n = copy.length;
        for (CoordinateSystemAxis axis : this.axes) {
            int i;
            block4: {
                for (i = 0; i < n; ++i) {
                    if (axis != copy[i]) {
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            System.arraycopy(copy, i + 1, copy, i, --n - i);
        }
        return n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final AbstractCS getCached(AxesConvention convention) {
        EnumMap<AxesConvention, AbstractCS> enumMap = this.forConvention;
        synchronized (enumMap) {
            return this.forConvention.get(convention);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final AbstractCS setCached(AxesConvention convention, AbstractCS cs) {
        EnumMap<AxesConvention, AbstractCS> enumMap = this.forConvention;
        synchronized (enumMap) {
            return this.forConvention.computeIfAbsent(convention, c -> {
                for (AbstractCS existing : this.forConvention.values()) {
                    if (!cs.equals(existing, ComparisonMode.IGNORE_METADATA)) continue;
                    return existing;
                }
                return cs;
            });
        }
    }

    public AbstractCS forConvention(AxesConvention convention) {
        AbstractCS cs = this.getCached(Objects.requireNonNull(convention));
        if (cs == null) {
            cs = Normalizer.forConvention(this, convention);
            if (cs == null) {
                cs = this;
            } else if (convention != AxesConvention.POSITIVE_RANGE) {
                cs = cs.resolveEPSG(this);
            }
            cs = this.setCached(convention, cs);
        }
        return cs;
    }

    AbstractCS createForAxes(String name, CoordinateSystemAxis[] axes) {
        return new AbstractCS(this, name, axes);
    }

    private AbstractCS resolveEPSG(AbstractCS original) {
        Integer epsg;
        if (IdentifiedObjects.getIdentifier(original, (Citation)Citations.EPSG) != null && (epsg = CoordinateSystems.getEpsgCode(this.getInterface(), this.axes)) != null) {
            try {
                CoordinateSystem fromDB;
                CRSAuthorityFactory factory = CRS.getAuthorityFactory("EPSG");
                if (factory instanceof CSAuthorityFactory && (fromDB = ((CSAuthorityFactory)factory).createCoordinateSystem(epsg.toString())) instanceof AbstractCS && Utilities.equalsIgnoreMetadata((Object)this.axes, (Object)((AbstractCS)fromDB).axes)) {
                    return (AbstractCS)fromDB;
                }
            }
            catch (FactoryException e) {
                Logging.recoverableException((Logger)LOGGER, this.getClass(), (String)"forConvention", (Throwable)e);
            }
        }
        return this;
    }

    static IllegalArgumentException unexpectedDimension(CoordinateSystemAxis[] axes, int min, int max) {
        int n = axes.length;
        int e = n < min ? min : max;
        return new MismatchedDimensionException(Errors.format((short)101, (Object)"filter(cs)", (Object)e, (Object)n));
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                return Arrays.equals(this.axes, ((AbstractCS)object).axes);
            }
            case DEBUG: 
            case ALLOW_VARIANT: {
                int dimension = this.getDimension();
                int that = ((CoordinateSystem)object).getDimension();
                assert (dimension == that || mode != ComparisonMode.DEBUG) : Errors.format((short)100, (Object)dimension, (Object)that);
                return dimension == that;
            }
        }
        CoordinateSystem that = (CoordinateSystem)object;
        int dimension = this.getDimension();
        if (dimension != that.getDimension()) {
            return false;
        }
        for (int i = 0; i < dimension; ++i) {
            if (Utilities.deepEquals((Object)this.getAxis(i), (Object)that.getAxis(i), (ComparisonMode)mode)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Arrays.hashCode(this.axes);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        String type = WKTUtilities.toType(CoordinateSystem.class, this.getInterface());
        if (type == null) {
            formatter.setInvalidWKT(this, null);
        }
        formatter.append(type, ElementKind.CODE_LIST);
        formatter.append(this.getDimension());
        return "CS";
    }

    AbstractCS() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
        this.forConvention = AbstractCS.forConvention(this);
        this.axes = EMPTY;
    }

    @XmlElement(name="axis")
    private CoordinateSystemAxis[] getAxis() {
        return this.axes;
    }

    private void setAxis(CoordinateSystemAxis[] values) {
        this.axes = values;
    }
}

