/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.internal.shared;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.internal.shared.FeatureProjectionBuilder;
import org.apache.sis.feature.internal.shared.FeatureView;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.internal.shared.ListingPropertyVisitor;
import org.apache.sis.io.TableAppender;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import org.apache.sis.util.resources.Vocabulary;

public final class FeatureProjection
implements UnaryOperator<AbstractFeature> {
    public final DefaultFeatureType typeRequested;
    public final DefaultFeatureType typeWithDependencies;
    private final String[] propertiesToCopy;
    private final Expression<? super AbstractFeature, ?>[] expressions;
    private final boolean createInstance;

    FeatureProjection(DefaultFeatureType typeRequested, DefaultFeatureType typeWithDependencies, List<FeatureProjectionBuilder.Item> projection) {
        this.createInstance = true;
        this.typeRequested = typeRequested;
        this.typeWithDependencies = typeWithDependencies;
        int storedCount = 0;
        Object[] expressions = new Expression[projection.size()];
        Object[] propertiesToCopy = new String[expressions.length];
        for (FeatureProjectionBuilder.Item item : projection) {
            Expression<? super AbstractFeature, ?> expression = item.attributeValueGetter();
            if (expression == null) continue;
            expressions[storedCount] = expression;
            propertiesToCopy[storedCount++] = item.getName();
        }
        this.propertiesToCopy = (String[])ArraysExt.resize((Object[])propertiesToCopy, (int)storedCount);
        this.expressions = (Expression[])ArraysExt.resize((Object[])expressions, (int)storedCount);
    }

    private FeatureProjection(FeatureProjection parent, int[] remaining) {
        this.createInstance = false;
        this.typeRequested = parent.typeRequested;
        this.typeWithDependencies = parent.typeWithDependencies;
        this.expressions = new Expression[remaining.length];
        this.propertiesToCopy = new String[remaining.length];
        for (int i = 0; i < remaining.length; ++i) {
            int index = remaining[i];
            this.propertiesToCopy[i] = parent.propertiesToCopy[index];
            this.expressions[i] = parent.expressions[index];
        }
    }

    public FeatureProjection afterPreprocessing(int[] remaining) {
        if (remaining.length == 0 && this.typeRequested == this.typeWithDependencies) {
            return null;
        }
        return new FeatureProjection(this, remaining);
    }

    public final List<String> propertiesToCopy() {
        return UnmodifiableArrayList.wrap((Object[])this.propertiesToCopy);
    }

    public Optional<String> xpath(int index) {
        Expression<AbstractFeature, ?> expression = this.expressions[index];
        if (expression instanceof ValueReference) {
            return Optional.of(((ValueReference)expression).getXPath());
        }
        return Optional.empty();
    }

    public Set<String> dependencies() {
        Set<String> references = null;
        for (Expression<? super AbstractFeature, ?> expression : this.expressions) {
            references = ListingPropertyVisitor.xpaths(expression, references);
        }
        return references != null ? references : Set.of();
    }

    @Override
    public AbstractFeature apply(AbstractFeature source) {
        AbstractFeature feature = this.createInstance ? this.typeWithDependencies.newInstance() : source;
        for (int i = 0; i < this.expressions.length; ++i) {
            feature.setPropertyValue(this.propertiesToCopy[i], this.expressions[i].apply(source));
        }
        if (this.typeRequested != this.typeWithDependencies) {
            feature = new FeatureView(this.typeRequested, feature);
        }
        return feature;
    }

    public String toString() {
        return Row.toString(this, this.propertiesToCopy);
    }

    private static final class Row {
        private final String property;
        private String xpath;
        private String type;

        static String toString(FeatureProjection projection, String[] propertiesToCopy) {
            LinkedHashMap<String, Row> rowByName = new LinkedHashMap<String, Row>();
            if (projection.typeWithDependencies != projection.typeRequested) {
                Row.addAll(rowByName, projection.typeWithDependencies, "dependency");
            }
            Row.addAll(rowByName, projection.typeRequested, "operation");
            for (int i = 0; i < propertiesToCopy.length; ++i) {
                String value;
                String name = propertiesToCopy[i];
                try {
                    name = projection.typeWithDependencies.getProperty(name).getName().toString();
                    value = "stored";
                }
                catch (RuntimeException e) {
                    value = e.toString();
                }
                Row row = rowByName.computeIfAbsent(name, Row::new);
                row.type = value;
                row.xpath = projection.xpath(i).orElse("");
            }
            Vocabulary words = Vocabulary.forLocale(null);
            TableAppender table = new TableAppender(" \u2502 ");
            table.setMultiLinesCells(true);
            table.appendHorizontalSeparator();
            table.append((CharSequence)words.getString((short)238)).nextColumn();
            table.append((CharSequence)words.getString((short)203)).nextColumn();
            table.append((CharSequence)"XPath").nextLine();
            table.appendHorizontalSeparator();
            for (Row row : rowByName.values()) {
                table.append((CharSequence)row.property).nextColumn();
                table.append((CharSequence)row.type).nextColumn();
                table.append((CharSequence)row.xpath).nextLine();
            }
            table.appendHorizontalSeparator();
            return table.toString();
        }

        private static void addAll(Map<String, Row> rowByName, DefaultFeatureType featureType, String type) {
            for (AbstractIdentifiedType property : featureType.getProperties(true)) {
                Row row = rowByName.computeIfAbsent(property.getName().toString(), Row::new);
                row.type = type;
            }
        }

        private Row(String name) {
            this.property = name;
            this.xpath = "";
        }
    }
}

