/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.client;

import org.apache.commons.configuration.Configuration;

public class ApolloConfig {
    public static final ApolloConfig INSTANCE = new ApolloConfig();
    private static Configuration finalConfig;
    private static final String SERVER_URL_KEY = "apollo.config.serverUri";
    private static final String SERVER_NAMESPACE = "apollo.config.namespace";
    private static final String SERVER_ENV = "apollo.config.env";
    private static final String SERVER_CLUSTERS = "apollo.config.clusters";
    private static final String APOLLO_SERVICE_NAME = "apollo.config.serviceName";
    private static final String TOKEN = "apollo.config.token";
    private static final String REFRESH_INTERVAL = "apollo.config.refreshInterval";
    private static final String FIRST_REFRESH_INTERVAL = "apollo.config.firstRefreshInterval";
    private static final int DEFAULT_REFRESH_INTERVAL = 3;
    private static final int DEFAULT_FIRST_REFRESH_INTERVAL = 0;

    private ApolloConfig() {
    }

    public static void setConcurrentCompositeConfiguration(Configuration config) {
        finalConfig = config;
    }

    public Configuration getConcurrentCompositeConfiguration() {
        return finalConfig;
    }

    public String getServiceName() {
        return finalConfig.getString(APOLLO_SERVICE_NAME);
    }

    public String getServerUri() {
        return finalConfig.getString(SERVER_URL_KEY);
    }

    public String getToken() {
        return finalConfig.getString(TOKEN);
    }

    public String getEnv() {
        return finalConfig.getString(SERVER_ENV);
    }

    public String getNamespace() {
        return finalConfig.getString(SERVER_NAMESPACE);
    }

    public String getServerClusters() {
        return finalConfig.getString(SERVER_CLUSTERS);
    }

    public int getRefreshInterval() {
        return finalConfig.getInt(REFRESH_INTERVAL, 3);
    }

    public int getFirstRefreshInterval() {
        return finalConfig.getInt(FIRST_REFRESH_INTERVAL, 0);
    }
}

