/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.subscription;

import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.subscription.SubscriptionGroupManager;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;

public class LmqSubscriptionGroupManager
extends SubscriptionGroupManager {
    public LmqSubscriptionGroupManager(BrokerController brokerController) {
        super(brokerController);
    }

    @Override
    public SubscriptionGroupConfig findSubscriptionGroupConfig(String group) {
        if (MixAll.isLmq((String)group)) {
            SubscriptionGroupConfig subscriptionGroupConfig = new SubscriptionGroupConfig();
            subscriptionGroupConfig.setGroupName(group);
            return subscriptionGroupConfig;
        }
        return super.findSubscriptionGroupConfig(group);
    }

    @Override
    public void updateSubscriptionGroupConfig(SubscriptionGroupConfig config) {
        if (config == null || MixAll.isLmq((String)config.getGroupName())) {
            return;
        }
        super.updateSubscriptionGroupConfig(config);
    }

    @Override
    public boolean containsSubscriptionGroup(String group) {
        if (MixAll.isLmq((String)group)) {
            return true;
        }
        return super.containsSubscriptionGroup(group);
    }
}

