/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.utils;

import com.alibaba.fastjson2.JSON;
import org.apache.commons.lang3.SerializationException;
import org.apache.rocketmq.common.utils.Serializer;

public class FastJsonSerializer
implements Serializer {
    @Override
    public <T> byte[] serialize(T t) throws SerializationException {
        if (t == null) {
            return new byte[0];
        }
        try {
            return JSON.toJSONBytes(t);
        }
        catch (Exception var3) {
            throw new SerializationException("Could not serialize: " + var3.getMessage(), (Throwable)var3);
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> type) throws SerializationException {
        if (bytes != null && bytes.length != 0) {
            try {
                return (T)JSON.parseObject((byte[])bytes, type);
            }
            catch (Exception var3) {
                throw new SerializationException("Could not deserialize: " + var3.getMessage(), (Throwable)var3);
            }
        }
        return null;
    }
}

