/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.file;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.common.TieredStoreExecutor;
import org.apache.rocketmq.tieredstore.file.CompositeFlatFile;
import org.apache.rocketmq.tieredstore.file.CompositeQueueFlatFile;
import org.apache.rocketmq.tieredstore.file.TieredFileAllocator;
import org.apache.rocketmq.tieredstore.index.IndexService;
import org.apache.rocketmq.tieredstore.index.IndexStoreService;
import org.apache.rocketmq.tieredstore.metadata.TieredMetadataStore;
import org.apache.rocketmq.tieredstore.util.TieredStoreUtil;

public class TieredFlatFileManager {
    private static final Logger BROKER_LOG = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final Logger logger = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    private static volatile TieredFlatFileManager instance;
    private static volatile IndexStoreService indexStoreService;
    private final TieredMetadataStore metadataStore;
    private final TieredMessageStoreConfig storeConfig;
    private final TieredFileAllocator tieredFileAllocator;
    private final ConcurrentMap<MessageQueue, CompositeQueueFlatFile> flatFileConcurrentMap;

    public TieredFlatFileManager(TieredMessageStoreConfig storeConfig) throws ClassNotFoundException, NoSuchMethodException {
        this.storeConfig = storeConfig;
        this.metadataStore = TieredStoreUtil.getMetadataStore(storeConfig);
        this.tieredFileAllocator = new TieredFileAllocator(storeConfig);
        this.flatFileConcurrentMap = new ConcurrentHashMap<MessageQueue, CompositeQueueFlatFile>();
        this.doScheduleTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TieredFlatFileManager getInstance(TieredMessageStoreConfig storeConfig) {
        if (storeConfig == null || instance != null) {
            return instance;
        }
        Class<TieredFlatFileManager> clazz = TieredFlatFileManager.class;
        synchronized (TieredFlatFileManager.class) {
            if (instance == null) {
                try {
                    instance = new TieredFlatFileManager(storeConfig);
                }
                catch (Exception e) {
                    logger.error("Construct FlatFileManager instance error", (Throwable)e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IndexService getTieredIndexService(TieredMessageStoreConfig storeConfig) {
        if (storeConfig == null) {
            return indexStoreService;
        }
        if (indexStoreService != null) return indexStoreService;
        Class<TieredFlatFileManager> clazz = TieredFlatFileManager.class;
        synchronized (TieredFlatFileManager.class) {
            if (indexStoreService != null) return indexStoreService;
            try {
                String filePath = TieredStoreUtil.toPath(new MessageQueue("rmq_sys_INDEX", storeConfig.getBrokerName(), 0));
                indexStoreService = new IndexStoreService(new TieredFileAllocator(storeConfig), filePath);
                indexStoreService.start();
            }
            catch (Exception e) {
                logger.error("Construct FlatFileManager indexFile error", (Throwable)e);
            }
            return indexStoreService;
        }
    }

    public void doCommit() {
        Random random = new Random();
        for (CompositeQueueFlatFile flatFile : this.deepCopyFlatFileToList()) {
            int delay = random.nextInt(this.storeConfig.getMaxCommitJitter());
            TieredStoreExecutor.commitExecutor.schedule(() -> {
                try {
                    flatFile.commitCommitLog();
                }
                catch (Throwable e) {
                    MessageQueue mq = flatFile.getMessageQueue();
                    logger.error("Commit commitLog periodically failed: topic: {}, queue: {}", new Object[]{mq.getTopic(), mq.getQueueId(), e});
                }
            }, (long)delay, TimeUnit.MILLISECONDS);
            TieredStoreExecutor.commitExecutor.schedule(() -> {
                try {
                    flatFile.commitConsumeQueue();
                }
                catch (Throwable e) {
                    MessageQueue mq = flatFile.getMessageQueue();
                    logger.error("Commit consumeQueue periodically failed: topic: {}, queue: {}", new Object[]{mq.getTopic(), mq.getQueueId(), e});
                }
            }, (long)delay, TimeUnit.MILLISECONDS);
        }
    }

    public void doCleanExpiredFile() {
        long expiredTimeStamp = System.currentTimeMillis() - TimeUnit.HOURS.toMillis(this.storeConfig.getTieredStoreFileReservedTime());
        for (CompositeQueueFlatFile flatFile : this.deepCopyFlatFileToList()) {
            TieredStoreExecutor.cleanExpiredFileExecutor.submit(() -> {
                try {
                    flatFile.getCompositeFlatFileLock().lock();
                    flatFile.cleanExpiredFile(expiredTimeStamp);
                    flatFile.destroyExpiredFile();
                }
                catch (Throwable t) {
                    logger.error("Do Clean expired file error, topic={}, queueId={}", new Object[]{flatFile.getMessageQueue().getTopic(), flatFile.getMessageQueue().getQueueId(), t});
                }
                finally {
                    flatFile.getCompositeFlatFileLock().unlock();
                }
            });
        }
    }

    private void doScheduleTask() {
        TieredStoreExecutor.commonScheduledExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.doCommit();
            }
            catch (Throwable e) {
                logger.error("Commit flat file periodically failed: ", e);
            }
        }, 60L, 60L, TimeUnit.SECONDS);
        TieredStoreExecutor.commonScheduledExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.doCleanExpiredFile();
            }
            catch (Throwable e) {
                logger.error("Clean expired flat file failed: ", e);
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    public boolean load() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.flatFileConcurrentMap.clear();
            this.recoverSequenceNumber();
            this.recoverTieredFlatFile();
            logger.info("Message store recover end, total cost={}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
        catch (Exception e) {
            long costTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            logger.info("Message store recover error, total cost={}ms", (Object)costTime);
            BROKER_LOG.error("Message store recover error, total cost={}ms", (Object)costTime, (Object)e);
            return false;
        }
        return true;
    }

    public void recoverSequenceNumber() {
        AtomicLong topicSequenceNumber = new AtomicLong();
        this.metadataStore.iterateTopic(topicMetadata -> {
            if (topicMetadata != null && topicMetadata.getTopicId() > 0L) {
                topicSequenceNumber.set(Math.max(topicSequenceNumber.get(), topicMetadata.getTopicId()));
            }
        });
        this.metadataStore.setTopicSequenceNumber(topicSequenceNumber.incrementAndGet());
    }

    public void recoverTieredFlatFile() {
        Semaphore semaphore = new Semaphore(7500);
        ArrayList futures = new ArrayList();
        this.metadataStore.iterateTopic(topicMetadata -> {
            try {
                semaphore.acquire();
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                    try {
                        Stopwatch subWatch = Stopwatch.createStarted();
                        if (topicMetadata.getStatus() != 0) {
                            return;
                        }
                        AtomicLong queueCount = new AtomicLong();
                        this.metadataStore.iterateQueue(topicMetadata.getTopic(), queueMetadata -> {
                            this.getOrCreateFlatFileIfAbsent(new MessageQueue(topicMetadata.getTopic(), this.storeConfig.getBrokerName(), queueMetadata.getQueue().getQueueId()));
                            queueCount.incrementAndGet();
                        });
                        if (queueCount.get() == 0L) {
                            this.metadataStore.deleteTopic(topicMetadata.getTopic());
                        } else {
                            logger.info("Recover TopicFlatFile, topic: {}, queueCount: {}, cost: {}ms", new Object[]{topicMetadata.getTopic(), queueCount.get(), subWatch.elapsed(TimeUnit.MILLISECONDS)});
                        }
                    }
                    catch (Exception e) {
                        logger.error("Recover TopicFlatFile error, topic: {}", (Object)topicMetadata.getTopic(), (Object)e);
                    }
                    finally {
                        semaphore.release();
                    }
                }, TieredStoreExecutor.commitExecutor);
                futures.add(future);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
    }

    public void cleanup() {
        this.flatFileConcurrentMap.clear();
        TieredFlatFileManager.cleanStaticReference();
    }

    private static void cleanStaticReference() {
        instance = null;
        indexStoreService = null;
    }

    @Nullable
    public CompositeQueueFlatFile getOrCreateFlatFileIfAbsent(MessageQueue messageQueue) {
        return this.flatFileConcurrentMap.computeIfAbsent(messageQueue, mq -> {
            try {
                logger.debug("Create new TopicFlatFile, topic: {}, queueId: {}", (Object)messageQueue.getTopic(), (Object)messageQueue.getQueueId());
                return new CompositeQueueFlatFile(this.tieredFileAllocator, (MessageQueue)mq);
            }
            catch (Exception e) {
                logger.debug("Create new TopicFlatFile failed, topic: {}, queueId: {}", new Object[]{messageQueue.getTopic(), messageQueue.getQueueId(), e});
                return null;
            }
        });
    }

    public CompositeQueueFlatFile getFlatFile(MessageQueue messageQueue) {
        return (CompositeQueueFlatFile)this.flatFileConcurrentMap.get(messageQueue);
    }

    public ImmutableList<CompositeQueueFlatFile> deepCopyFlatFileToList() {
        return ImmutableList.copyOf(this.flatFileConcurrentMap.values());
    }

    public void shutdown() {
        if (indexStoreService != null) {
            indexStoreService.shutdown();
        }
        for (CompositeFlatFile flatFile : this.deepCopyFlatFileToList()) {
            flatFile.shutdown();
        }
    }

    public void destroy() {
        if (indexStoreService != null) {
            indexStoreService.destroy();
        }
        ImmutableList<CompositeQueueFlatFile> flatFileList = this.deepCopyFlatFileToList();
        this.cleanup();
        for (CompositeFlatFile flatFile : flatFileList) {
            flatFile.destroy();
        }
    }

    public void destroyCompositeFile(MessageQueue mq) {
        if (mq == null) {
            return;
        }
        CompositeQueueFlatFile flatFile = (CompositeQueueFlatFile)this.flatFileConcurrentMap.remove(mq);
        if (flatFile != null) {
            MessageQueue messageQueue = flatFile.getMessageQueue();
            logger.info("TieredFlatFileManager#destroyCompositeFile: try to destroy composite flat file: topic: {}, queueId: {}", (Object)messageQueue.getTopic(), (Object)messageQueue.getQueueId());
            flatFile.destroy();
        }
    }
}

