/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common;

public class KeyBuilder {
    public static final int POP_ORDER_REVIVE_QUEUE = 999;
    private static final char POP_RETRY_SEPARATOR_V1 = '_';
    private static final char POP_RETRY_SEPARATOR_V2 = '+';
    private static final String POP_RETRY_REGEX_SEPARATOR_V2 = "\\+";

    public static String buildPopRetryTopic(String topic, String cid, boolean enableRetryV2) {
        if (enableRetryV2) {
            return KeyBuilder.buildPopRetryTopicV2(topic, cid);
        }
        return KeyBuilder.buildPopRetryTopicV1(topic, cid);
    }

    public static String buildPopRetryTopic(String topic, String cid) {
        return "%RETRY%" + cid + '_' + topic;
    }

    public static String buildPopRetryTopicV2(String topic, String cid) {
        return "%RETRY%" + cid + '+' + topic;
    }

    public static String buildPopRetryTopicV1(String topic, String cid) {
        return "%RETRY%" + cid + '_' + topic;
    }

    public static String parseNormalTopic(String topic, String cid) {
        if (topic.startsWith("%RETRY%")) {
            if (topic.startsWith("%RETRY%" + cid + '+')) {
                return topic.substring(("%RETRY%" + cid + '+').length());
            }
            return topic.substring(("%RETRY%" + cid + '_').length());
        }
        return topic;
    }

    public static String parseNormalTopic(String retryTopic) {
        String[] result;
        if (KeyBuilder.isPopRetryTopicV2(retryTopic) && (result = retryTopic.split(POP_RETRY_REGEX_SEPARATOR_V2)).length == 2) {
            return result[1];
        }
        return retryTopic;
    }

    public static String parseGroup(String retryTopic) {
        String[] result;
        if (KeyBuilder.isPopRetryTopicV2(retryTopic) && (result = retryTopic.split(POP_RETRY_REGEX_SEPARATOR_V2)).length == 2) {
            return result[0].substring("%RETRY%".length());
        }
        return retryTopic.substring("%RETRY%".length());
    }

    public static String buildPollingKey(String topic, String cid, int queueId) {
        return topic + "@" + cid + "@" + queueId;
    }

    public static boolean isPopRetryTopicV2(String retryTopic) {
        return retryTopic.startsWith("%RETRY%") && retryTopic.contains(String.valueOf('+'));
    }
}

